/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.scenegraph.GMaterial;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.util.BinUtil;
import hmi.util.BinaryExternalizable;
import hmi.util.Diff;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;

public class GShape
extends XMLStructureAdapter
implements BinaryExternalizable,
Diff.Differentiable {
    private GMesh gmesh;
    private GMaterial gmaterial;
    private String name = "";
    private static final String XMLTAG = "gshape";

    public GShape() {
    }

    public GShape(GMesh gmesh, GMaterial gmaterial, String name) {
        this.gmesh = gmesh;
        this.gmaterial = gmaterial;
        this.name = name;
    }

    public GShape(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public String showDiff(Object gshapeObj) {
        GShape gshape = (GShape)((Object)gshapeObj);
        if (gshape == null) {
            return "GShape " + this.name + ", diff: null GShape";
        }
        String diff = Diff.showDiff((String)"GShape, name", (String)this.name, (String)gshape.name);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GShape " + this.name + ", diff gmaterial"), (Diff.Differentiable)this.gmaterial, (Diff.Differentiable)gshape.gmaterial);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GShape " + this.name + ", diff gmesh"), (Diff.Differentiable)this.gmesh, (Diff.Differentiable)gshape.gmesh);
        if (diff != "") {
            return diff;
        }
        return "";
    }

    public void setGMesh(GMesh gmesh) {
        this.gmesh = gmesh;
    }

    public GMesh getGMesh() {
        return this.gmesh;
    }

    public void setGMaterial(GMaterial gmaterial) {
        this.gmaterial = gmaterial;
    }

    public GMaterial getGMaterial() {
        return this.gmaterial;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void affineTransform(float[] mat4x4) {
        if (this.gmesh != null) {
            this.gmesh.affineTransform(mat4x4);
        }
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        GShape.appendAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.name = this.getOptionalAttribute("name", attrMap);
        if (this.name != null) {
            this.name = this.name.intern();
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.gmaterial);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.gmesh);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(GMaterial.xmlTag())) {
                this.gmaterial = new GMaterial(tokenizer);
                continue;
            }
            if (tag.equals(GMesh.xmlTag())) {
                this.gmesh = new GMesh(tokenizer);
                continue;
            }
            if (tag.equals(GSkinnedMesh.xmlTag())) {
                this.gmesh = new GSkinnedMesh(tokenizer);
                continue;
            }
            System.out.println(tokenizer.getErrorMessage("GShape: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        dataOut.writeUTF(this.name);
        BinUtil.writeOptionalBinary((DataOutput)dataOut, (BinaryExternalizable)this.gmaterial);
        if (this.gmesh == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(this.gmesh instanceof GSkinnedMesh ? 2 : 1);
            this.gmesh.writeBinary(dataOut);
        }
    }

    public void readBinary(DataInput dataIn) throws IOException {
        this.name = dataIn.readUTF().intern();
        this.gmaterial = (GMaterial)BinUtil.readOptionalBinary((DataInput)dataIn, GMaterial.class);
        int gmeshClass = dataIn.readInt();
        if (gmeshClass < 0) {
            this.gmesh = null;
            return;
        }
        this.gmesh = gmeshClass == 1 ? new GMesh() : new GSkinnedMesh();
        this.gmesh.readBinary(dataIn);
    }
}

