/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GShape;
import hmi.math.Mat3f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.BinUtil;
import hmi.util.BinaryExternalizable;
import hmi.util.Console;
import hmi.util.Diff;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GNode
extends XMLStructureAdapter
implements BinaryExternalizable,
Diff.Differentiable {
    private String id;
    private String sid;
    private String name;
    private String type;
    private GNode parent;
    private List<GNode> gnodes;
    private List<GShape> gshapes;
    private VJoint joint = new VJoint();
    private static final List<GNode> EMPTYGNODELIST = new ArrayList<GNode>(0);
    private static final List<GShape> EMPTYGSHAPELIST = new ArrayList<GShape>(0);
    private float[] vec = Vec3f.getVec3f();
    private static final int LISTSIZE = 4;
    private static final String XMLTAG = "gnode";

    public GNode() {
    }

    public GNode(String id) {
        this();
        this.setId(id);
    }

    public GNode(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public String showDiff(Object gnodeObj) {
        GNode gnode = (GNode)((Object)gnodeObj);
        if (gnode == null) {
            return "GNode " + this.id + ", diff: null GNode";
        }
        String diff = Diff.showDiff((String)"GNode, id", (String)this.id, (String)gnode.id);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GNode " + this.id + ", diff sid"), (String)this.sid, (String)gnode.sid);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GNode " + this.id + ", diff name"), (String)this.name, (String)gnode.name);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GNode " + this.id + ", diff type"), (String)this.type, (String)gnode.type);
        if (diff != "") {
            return diff;
        }
        String parId1 = this.parent == null ? null : this.parent.getId();
        String parId2 = gnode.parent == null ? null : gnode.parent.getId();
        diff = Diff.showDiff((String)("GNode " + this.id + ", diff parent"), (String)parId1, (String)parId2);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GNode " + this.id + ", diff gshapes"), this.gshapes, gnode.gshapes);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GNode " + this.id + ", diff child nodes"), this.gnodes, gnode.gnodes);
        if (diff != "") {
            return diff;
        }
        diff = this.joint.showLocalDiff("GNode " + this.id + ", diff VJoints ", (Object)gnode.joint);
        if (diff != "") {
            return diff;
        }
        return "";
    }

    public void setId(String id) {
        this.id = id == null ? null : id.intern();
        this.joint.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setSid(String sid) {
        this.sid = sid == null ? null : sid.intern();
        this.joint.setSid(sid);
    }

    public String getSid() {
        return this.sid;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.intern();
        this.joint.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.intern();
    }

    public String getType() {
        return this.type;
    }

    public List<GNode> selectGNodes() {
        return this.selectGNodes(null, null);
    }

    public List<GNode> selectGNodes(Predicate select) {
        return this.selectGNodes(select, null);
    }

    public List<GNode> selectGNodes(Predicate select, Predicate prune) {
        return this.selectGNodes(select, prune, new ArrayList<GNode>());
    }

    public List<GNode> selectGNodes(Predicate select, Predicate prune, ArrayList<GNode> list) {
        if (select == null || select.valid(this)) {
            list.add(this);
        }
        if (prune == null || !prune.valid(this)) {
            for (GNode gchild : this.gnodes) {
                gchild.selectGNodes(select, prune, list);
            }
        }
        return list;
    }

    public VJoint getVJoint() {
        return this.joint;
    }

    public void addChildNode(GNode sn) {
        if (this.gnodes == null) {
            this.gnodes = new ArrayList<GNode>(4);
        }
        if (sn.parent != null) {
            sn.parent.removeChildNode(sn);
        }
        this.gnodes.add(sn);
        sn.parent = this;
        this.joint.addChild(sn.getVJoint());
    }

    public void removeChildNode(GNode sn) {
        if (this.gnodes == null) {
            return;
        }
        this.gnodes.remove((Object)sn);
    }

    public List<GNode> getChildNodes() {
        if (this.gnodes == null) {
            return EMPTYGNODELIST;
        }
        return this.gnodes;
    }

    public GNode getParent() {
        return this.parent;
    }

    public void addGShape(GShape gshape) {
        if (this.gshapes == null) {
            this.gshapes = new ArrayList<GShape>(4);
        }
        this.gshapes.add(gshape);
    }

    public void addGShapes(List<GShape> gshapeList) {
        if (this.gshapes == null) {
            this.gshapes = new ArrayList<GShape>(4);
        }
        this.gshapes.addAll(gshapeList);
    }

    public List<GShape> getGShapes() {
        if (this.gshapes == null) {
            return EMPTYGSHAPELIST;
        }
        return this.gshapes;
    }

    public boolean hasGShapes() {
        if (this.getGShapes().size() > 0) {
            return true;
        }
        for (GNode childNode : this.getChildNodes()) {
            if (!childNode.hasGShapes()) continue;
            return true;
        }
        return false;
    }

    public GNode getPartBySid(String sid) {
        if (this.sid != null && this.sid.equals(sid)) {
            return this;
        }
        for (GNode childNode : this.getChildNodes()) {
            GNode gn = childNode.getPartBySid(sid);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public GNode getPartById(String id) {
        if (this.id != null && this.id.equals(id)) {
            return this;
        }
        for (GNode childNode : this.getChildNodes()) {
            GNode gn = childNode.getPartById(id);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public GNode getPart(String id_or_sid) {
        if (this.sid != null && this.sid.equals(id_or_sid)) {
            return this;
        }
        if (this.id != null && this.id.equals(id_or_sid)) {
            return this;
        }
        for (GNode childNode : this.getChildNodes()) {
            GNode gn = childNode.getPart(id_or_sid);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public GNode getPartByNamePattern(String namePattern) {
        return this.getPartByNamePattern(Pattern.compile(namePattern));
    }

    public GNode getPartByNamePattern(Pattern namePat) {
        if (this.name != null && namePat.matcher(this.name).matches()) {
            return this;
        }
        for (GNode childNode : this.getChildNodes()) {
            GNode gn = childNode.getPartByNamePattern(namePat);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public void renameJoints(Map<String, String> renaming) {
        String newName = null;
        if (this.sid != null) {
            newName = renaming.get(this.sid);
        }
        if (newName != null) {
            this.setSid(newName);
        }
        for (GNode childNode : this.getChildNodes()) {
            childNode.renameJoints(renaming);
        }
    }

    public void setTranslation(float[] translation) {
        this.joint.setTranslation(translation);
    }

    public void getTranslation(float[] result) {
        this.joint.getTranslation(result);
    }

    public float[] getTranslation() {
        float[] result = Vec3f.getVec3f();
        this.joint.getTranslation(result);
        return result;
    }

    public void setRotation(float[] rotation) {
        this.joint.setRotation(rotation);
    }

    public void getRotation(float[] rotation) {
        this.joint.getRotation(rotation);
    }

    public float[] getRotation() {
        float[] result = Quat4f.getQuat4f();
        this.joint.getRotation(result);
        return result;
    }

    public void setScale(float[] scaleVec) {
        this.joint.setScale(scaleVec);
    }

    public void getScale(float[] scaleVec) {
        this.joint.getScale(scaleVec);
    }

    public float[] getScale() {
        float[] result = Vec3f.getVec3f();
        this.joint.getScale(result);
        return result;
    }

    public void setSkewMatrix(float[] skewMatrix) {
        this.joint.setSkewMatrix(skewMatrix);
    }

    public void setLocalTransform(float[] m) {
        this.joint.setLocalTransform(m);
    }

    public float[] getLocalMatrix() {
        return this.joint.getLocalMatrix();
    }

    public float[] getGlobalMatrix() {
        return this.joint.getGlobalMatrix();
    }

    public void clearLocalLinearTransform() {
        this.joint.clearLocalLinearTransform();
    }

    public void clearRotations() {
        this.joint.clearRotation();
        for (GNode child : this.getChildNodes()) {
            child.clearRotations();
        }
    }

    public void clearJointRotations() {
        if (this.type == "JOINT" || this.type == "Joint") {
            this.joint.clearRotation();
        }
        for (GNode child : this.getChildNodes()) {
            child.clearJointRotations();
        }
    }

    public void affineTransformVJoint(float[] mat4x4) {
        this.joint.affineTransform(mat4x4);
        for (GNode child : this.getChildNodes()) {
            child.affineTransformVJoint(mat4x4);
        }
    }

    public void affineTransformGShapes(float[] mat4x4) {
        for (GShape gshape : this.getGShapes()) {
            gshape.affineTransform(mat4x4);
        }
        for (GNode child : this.getChildNodes()) {
            child.affineTransformGShapes(mat4x4);
        }
    }

    public void affineTransform(float[] mat4x4) {
        this.joint.affineTransform(mat4x4);
        for (GShape gshape : this.getGShapes()) {
            gshape.affineTransform(mat4x4);
        }
        for (GNode child : this.getChildNodes()) {
            child.affineTransform(mat4x4);
        }
    }

    public void removeLinearTransforms() {
        this.removeLinearTransforms(Mat3f.getIdentity());
    }

    public void removeLinearTransforms(float[] mat3x3) {
        float[] localLinear = Mat3f.from4x4((float[])this.joint.getLocalMatrix());
        float[] combinedTransform = Mat3f.getMat3f();
        Mat3f.mul((float[])combinedTransform, (float[])mat3x3, (float[])localLinear);
        for (GShape gs : this.getGShapes()) {
            gs.getGMesh().linearTransform(combinedTransform);
        }
        this.joint.getTranslation(this.vec);
        Mat3f.transform((float[])mat3x3, (float[])this.vec);
        this.joint.setTranslation(this.vec);
        this.joint.clearLocalLinearTransform();
        for (GNode child : this.getChildNodes()) {
            child.removeLinearTransforms(combinedTransform);
        }
    }

    public String toString() {
        return this.toXMLString();
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        GNode.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        GNode.appendAttribute((StringBuilder)buf, (String)"sid", (String)this.sid);
        GNode.appendAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        GNode.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        GNode.appendAttribute((StringBuilder)buf, (String)"translation", (float[])this.getTranslation(), (char)' ');
        GNode.appendAttribute((StringBuilder)buf, (String)"rotation", (float[])this.getRotation(), (char)' ');
        GNode.appendAttribute((StringBuilder)buf, (String)"scale", (float[])this.getScale(), (char)' ');
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String sc;
        String rot;
        this.setId(this.getOptionalAttribute("id", attrMap));
        this.setSid(this.getOptionalAttribute("sid", attrMap));
        this.setName(this.getOptionalAttribute("name", attrMap));
        this.setType(this.getOptionalAttribute("type", attrMap));
        String tr = this.getOptionalAttribute("translation", attrMap);
        if (tr != null) {
            this.setTranslation(GNode.decodeFloatArray((String)tr));
        }
        if ((rot = this.getOptionalAttribute("rotation", attrMap)) != null) {
            this.setRotation(GNode.decodeFloatArray((String)rot));
        }
        if ((sc = this.getOptionalAttribute("scale", attrMap)) != null) {
            this.setScale(GNode.decodeFloatArray((String)sc));
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        GNode.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.gnodes);
        GNode.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.gshapes);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(GNode.xmlTag())) {
                this.addChildNode(new GNode(tokenizer));
                continue;
            }
            if (tag.equals(GShape.xmlTag())) {
                this.addGShape(new GShape(tokenizer));
                continue;
            }
            Console.println((String)tokenizer.getErrorMessage("GNode: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        BinUtil.writeOptionalString((DataOutput)dataOut, (String)this.id);
        BinUtil.writeOptionalString((DataOutput)dataOut, (String)this.sid);
        BinUtil.writeOptionalString((DataOutput)dataOut, (String)this.name);
        BinUtil.writeOptionalString((DataOutput)dataOut, (String)this.type);
        BinUtil.writeFloatArray((DataOutput)dataOut, (float[])this.getTranslation());
        BinUtil.writeFloatArray((DataOutput)dataOut, (float[])this.getRotation());
        BinUtil.writeFloatArray((DataOutput)dataOut, (float[])this.getScale());
        BinUtil.writeBinaryList((DataOutput)dataOut, this.gshapes);
        BinUtil.writeBinaryList((DataOutput)dataOut, this.gnodes);
    }

    public void readBinary(DataInput dataIn) throws IOException {
        this.setId(BinUtil.readOptionalString((DataInput)dataIn));
        this.setSid(BinUtil.readOptionalString((DataInput)dataIn));
        this.setName(BinUtil.readOptionalString((DataInput)dataIn));
        this.setType(BinUtil.readOptionalString((DataInput)dataIn));
        this.setTranslation(BinUtil.readFloatArray((DataInput)dataIn));
        this.setRotation(BinUtil.readFloatArray((DataInput)dataIn));
        this.setScale(BinUtil.readFloatArray((DataInput)dataIn));
        this.gshapes = BinUtil.readBinaryList((DataInput)dataIn, GShape.class);
        ArrayList childNodes = BinUtil.readBinaryList((DataInput)dataIn, GNode.class);
        if (childNodes == null) {
            this.gnodes = null;
        } else {
            for (GNode child : childNodes) {
                this.addChildNode(child);
            }
        }
    }

    public static interface Predicate {
        public boolean valid(GNode var1);
    }
}

