/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.geometry.Triangulator;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.math.Mat3f;
import hmi.math.Vec3f;
import hmi.util.BinUtil;
import hmi.util.BinaryExternalizable;
import hmi.util.Console;
import hmi.util.Diff;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class GMesh
extends XMLStructureAdapter
implements BinaryExternalizable,
Diff.Differentiable {
    private static final int ATTRIBUTELIST_SIZE = 32;
    private String id;
    private MeshType meshType = MeshType.Undefined;
    private ArrayList<VertexAttribute> attributeList = new ArrayList(32);
    private String[] morphTargets = null;
    private ArrayList<ArrayList<VertexAttribute>> morphAttributeLists = null;
    private int[] vcounts;
    private int[] indexData;
    private int nrOfVertices = -1;
    private boolean unifiedIndexData = true;
    private static Logger logger = GScene.getLogger();
    private static String[] attrOrder = new String[]{"mcPosition", "mcNormal", "color", "secondaryColor", "texCoord0", "texCoord1", "texCoord2", "texCoord3", "texCoord4", "texCoord5", "texCoord6"};
    private static final int VERTEXCOORD_SIZE = 3;
    private static final double TUPLEINDEX_GROW_GUESTIMATE = 1.5;
    private static boolean showGMeshData = false;
    private static final int INDICESPERLINE = 30;
    private static final int STRINGSPERLINE = 15;
    private static final String XMLTAG = "gmesh";

    public GMesh() {
    }

    public GMesh(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public GMesh(GMesh base) {
        this();
        this.id = base.id;
        this.meshType = base.meshType;
        this.attributeList = base.attributeList;
        this.morphTargets = base.morphTargets;
        this.morphAttributeLists = base.morphAttributeLists;
        this.vcounts = base.vcounts;
        this.indexData = base.indexData;
        this.nrOfVertices = base.nrOfVertices;
        this.unifiedIndexData = base.unifiedIndexData;
    }

    public String showDiff(Object gmObj) {
        GMesh gm = (GMesh)((Object)gmObj);
        if (gm == null) {
            return "GMesh " + this.id + ", diff: null GMesh";
        }
        String diff = Diff.showDiff((String)"GMesh, id", (String)this.id, (String)gm.id);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff meshType"), (String)this.meshType.toString(), (String)gm.meshType.toString());
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff attributes"), this.attributeList, gm.attributeList);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff morphTargets"), (String[])this.morphTargets, (String[])gm.morphTargets);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff2((String)("GMesh " + this.id + ", diff morphAttributeLists"), this.morphAttributeLists, gm.morphAttributeLists);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff vcounts"), (int[])this.vcounts, (int[])gm.vcounts);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff indexData"), (int[])this.indexData, (int[])gm.indexData);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff nrOfVertices"), (int)this.nrOfVertices, (int)gm.nrOfVertices);
        if (diff != "") {
            return diff;
        }
        diff = Diff.showDiff((String)("GMesh " + this.id + ", diff unifiedIndexData"), (boolean)this.unifiedIndexData, (boolean)gm.unifiedIndexData);
        if (diff != "") {
            return diff;
        }
        return "";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setMeshType(MeshType t) {
        this.meshType = t;
    }

    public MeshType getMeshType() {
        return this.meshType;
    }

    public void setMorphTargets(String[] morphTargets) {
        this.morphTargets = morphTargets;
        this.morphAttributeLists = new ArrayList(morphTargets.length);
        for (int i = 0; i < morphTargets.length; ++i) {
            this.morphAttributeLists.add(new ArrayList(2));
        }
    }

    public String[] getMorphTargets() {
        return this.morphTargets;
    }

    public float[][] getMorphData(String semantic) {
        float[][] morphData = new float[this.morphTargets.length][];
        block0: for (int i = 0; i < morphData.length; ++i) {
            ArrayList<VertexAttribute> tgAttrList = this.morphAttributeLists.get(i);
            for (VertexAttribute attr : tgAttrList) {
                if (!attr.getName().equals(semantic)) continue;
                morphData[i] = attr.getVertexData();
                continue block0;
            }
        }
        return morphData;
    }

    public int morphListSize() {
        if (this.morphAttributeLists == null) {
            return -1;
        }
        return this.morphAttributeLists.size();
    }

    private VertexAttribute requestVertexAttribute(int morphTarget, String attributeName) {
        ArrayList<VertexAttribute> atList = morphTarget < 0 ? this.attributeList : this.morphAttributeLists.get(morphTarget);
        for (VertexAttribute attr : atList) {
            if (!attributeName.equals(attr.getName())) continue;
            return attr;
        }
        VertexAttribute attr = new VertexAttribute(attributeName);
        this.addVertexAttribute(morphTarget, attr);
        return attr;
    }

    private void addVertexAttribute(int morphTarget, VertexAttribute attr) {
        ArrayList<VertexAttribute> atList = morphTarget < 0 ? this.attributeList : this.morphAttributeLists.get(morphTarget);
        for (int i = 0; i < atList.size(); ++i) {
            if (this.attrOrd(attr.getName()) >= this.attrOrd(((VertexAttribute)((Object)atList.get(i))).getName())) continue;
            atList.add(i, attr);
            return;
        }
        atList.add(atList.size(), attr);
    }

    private int attrOrd(String attrName) {
        for (int i = 0; i < attrOrder.length; ++i) {
            if (!attrName.equals(attrOrder[i])) continue;
            return i;
        }
        return attrOrder.length;
    }

    public VertexAttribute getVertexAttribute(String attributeName) {
        return this.getVertexAttribute(-1, attributeName);
    }

    public VertexAttribute getVertexAttribute(int morphTarget, String attributeName) {
        ArrayList<VertexAttribute> atList;
        if (morphTarget >= 0 && this.morphAttributeLists == null) {
            return null;
        }
        ArrayList<VertexAttribute> arrayList = atList = morphTarget < 0 ? this.attributeList : this.morphAttributeLists.get(morphTarget);
        if (atList == null) {
            return null;
        }
        for (VertexAttribute attr : atList) {
            if (!attributeName.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public ArrayList<VertexAttribute> getVertexAttributeList() {
        return this.attributeList;
    }

    public ArrayList<VertexAttribute> getVertexAttributeList(int morphTarget) {
        if (morphTarget < 0) {
            return this.attributeList;
        }
        if (this.morphAttributeLists == null) {
            return null;
        }
        return this.morphAttributeLists.get(morphTarget);
    }

    public List<String> getVertexAttributeNameList(int morphTarget) {
        ArrayList<VertexAttribute> atlist = morphTarget < 0 ? this.attributeList : this.morphAttributeLists.get(morphTarget);
        ArrayList<String> result = new ArrayList<String>(8);
        for (VertexAttribute va : atlist) {
            result.add(va.getName());
        }
        return result;
    }

    public boolean checkMorphTargetConsistency(String attrName) {
        int nrOfMorphs = this.morphAttributeLists.size();
        boolean result = true;
        for (int i = 0; i < nrOfMorphs; ++i) {
            result = result && this.checkMorphTargetConsistency(i, attrName);
        }
        return result;
    }

    public boolean checkMorphTargetConsistency(int morphTarget, String attrName) {
        float[] basemeshData = null;
        for (VertexAttribute attr : this.attributeList) {
            if (!attr.getName().equals(attrName)) continue;
            basemeshData = attr.getVertexData();
            break;
        }
        float[] morphData = null;
        ArrayList<VertexAttribute> tgAttrList = this.morphAttributeLists.get(morphTarget);
        for (VertexAttribute attr : tgAttrList) {
            if (!attr.getName().equals(attrName)) continue;
            morphData = attr.getVertexData();
            break;
        }
        if (basemeshData == null) {
            Console.println((String)"Null basemeshData");
            return false;
        }
        if (morphData == null) {
            return false;
        }
        boolean result = morphData.length == basemeshData.length;
        return result;
    }

    public void setVertexData(String attributeName, int dataElementSize, float[] vertexData) {
        this.setVertexData(-1, attributeName, dataElementSize, vertexData);
    }

    public void setVertexData(int morphTarget, String attributeName, int dataElementSize, float[] vertexData) {
        VertexAttribute attr = this.requestVertexAttribute(morphTarget, attributeName);
        attr.setAttributeValueSize(dataElementSize);
        attr.setVertexData(vertexData);
    }

    public void setIndexedVertexData(String attributeName, int dataElementSize, float[] vertexData, int[] indexData) {
        this.setIndexedVertexData(-1, attributeName, dataElementSize, vertexData, indexData);
    }

    public void setIndexedVertexData(int morphTarget, String attributeName, int dataElementSize, float[] vertexData, int[] vertexIndexData) {
        if (this.indexData != null) {
            throw new IllegalStateException("GMesh.setIndexedVertexdata not legal when shared indexData has been set or indices have been unified");
        }
        VertexAttribute attr = this.requestVertexAttribute(morphTarget, attributeName);
        attr.setAttributeValueSize(dataElementSize);
        attr.setVertexData(vertexData);
        attr.setIndexData(vertexIndexData);
        this.unifiedIndexData = false;
    }

    public float[] getVertexData(String attributeName) {
        return this.getVertexData(-1, attributeName);
    }

    public float[] getVertexData(int morphTarget, String attributeName) {
        ArrayList<VertexAttribute> atList = morphTarget < 0 ? this.attributeList : this.morphAttributeLists.get(morphTarget);
        for (VertexAttribute attr : atList) {
            if (!attributeName.equals(attr.getName())) continue;
            return attr.getVertexData();
        }
        return null;
    }

    public int[] getAttributeIndexData(String attributeName) {
        return this.getAttributeIndexData(-1, attributeName);
    }

    public int[] getAttributeIndexData(int morphTarget, String attributeName) {
        ArrayList<VertexAttribute> atList;
        ArrayList<VertexAttribute> arrayList = atList = morphTarget < 0 ? this.attributeList : this.morphAttributeLists.get(morphTarget);
        if (this.hasUnifiedIndexData()) {
            throw new IllegalStateException("GMesh.getAttributeIndexData not legal when indices are unified");
        }
        for (VertexAttribute attr : atList) {
            if (!attributeName.equals(attr.getName())) continue;
            return attr.getIndexData();
        }
        return null;
    }

    public int[] getIndexData() {
        if (!this.hasUnifiedIndexData()) {
            throw new IllegalStateException("GMesh.getIndexData not legal when indices are not unified");
        }
        return this.indexData;
    }

    public void setIndexData(int[] indexData) {
        if (!this.hasUnifiedIndexData()) {
            throw new IllegalStateException("GMesh.setIndexData not legal when indices are not unified");
        }
        this.indexData = indexData;
    }

    public int getNrOfAttributes() {
        return this.attributeList == null ? -1 : this.attributeList.size();
    }

    public int getNrOfIndices() {
        return this.indexData == null ? -1 : this.indexData.length;
    }

    public int getNrOfVertices() {
        return this.nrOfVertices;
    }

    public void setVCountData(int[] counts) {
        this.vcounts = counts;
    }

    public int[] getVCountData() {
        return this.vcounts;
    }

    public void affineTransform(float[] mat4x4) {
        VertexAttribute normalAttribute;
        VertexAttribute coordAttribute = this.getVertexAttribute("mcPosition");
        if (coordAttribute != null) {
            coordAttribute.affineTransform(mat4x4);
            if (this.morphAttributeLists != null) {
                for (int morphTarget = 0; morphTarget < this.morphAttributeLists.size(); ++morphTarget) {
                    VertexAttribute coordAttr = this.getVertexAttribute(morphTarget, "mcPosition");
                    if (coordAttr == null) continue;
                    coordAttr.affineTransform(mat4x4);
                }
            }
        }
        if ((normalAttribute = this.getVertexAttribute("mcNormal")) != null) {
            float[] normalTransformMatrix = Mat3f.getMat3f();
            Mat3f.invertTransposeMat4f((float[])normalTransformMatrix, (float[])mat4x4);
            normalAttribute.linearTransform(normalTransformMatrix);
            if (this.morphAttributeLists != null) {
                for (int morphTarget = 0; morphTarget < this.morphAttributeLists.size(); ++morphTarget) {
                    VertexAttribute normalAttr = this.getVertexAttribute(morphTarget, "mcNormal");
                    if (normalAttr == null) continue;
                    normalAttr.affineTransform(mat4x4);
                }
            }
        }
    }

    public void linearTransform(float[] mat3x3) {
        VertexAttribute normalAttribute;
        VertexAttribute coordAttribute = this.getVertexAttribute("mcPosition");
        if (coordAttribute != null) {
            coordAttribute.linearTransform(mat3x3);
        }
        if ((normalAttribute = this.getVertexAttribute("mcNormal")) != null) {
            float[] normalTransformMatrix = Mat3f.getMat3f();
            Mat3f.invertTranspose((float[])normalTransformMatrix, (float[])mat3x3);
            normalAttribute.linearTransform(normalTransformMatrix);
        }
    }

    public boolean checkIndexIntegrity() {
        if (this.indexData == null) {
            Console.println((String)"checkIndexIntegrity: null indexData");
            return false;
        }
        for (int i = 0; i < this.indexData.length; ++i) {
            if (this.indexData[i] >= 0 && this.indexData[i] < this.nrOfVertices) continue;
            Console.println((String)("checkIndexIntegrity found out of range  index: " + this.indexData[i] + " (nrOfVertices== " + this.nrOfVertices + ")"));
            return false;
        }
        return true;
    }

    public boolean checkTriangleIntegrity(float minSize) {
        VertexAttribute coordsAttribute = this.getVertexAttribute("mcPosition");
        float[] coords = coordsAttribute.getVertexData();
        float[] u = new float[3];
        float[] v = new float[3];
        float[] c = new float[3];
        for (int tribase = 0; tribase < this.indexData.length; tribase += 3) {
            int p = tribase;
            int q = tribase + 1;
            int r = tribase + 2;
            Vec3f.sub((float[])u, (int)0, (float[])coords, (int)this.indexData[q], (float[])coords, (int)this.indexData[p]);
            Vec3f.sub((float[])v, (int)0, (float[])coords, (int)this.indexData[r], (float[])coords, (int)this.indexData[p]);
            Vec3f.cross((float[])c, (float[])u, (float[])v);
            float len = Vec3f.length((float[])c);
            if (!(len <= minSize)) continue;
            Console.println((String)("tri size: " + len));
        }
        return true;
    }

    public void cleanupTriangles(float minSize) {
        VertexAttribute coordsAttribute = this.getVertexAttribute("mcPosition");
        float[] coords = coordsAttribute.getVertexData();
        float[] u = new float[3];
        float[] v = new float[3];
        float[] c = new float[3];
        int[] newIndices = new int[this.indexData.length];
        int copyIndex = 0;
        for (int tribase = 0; tribase < this.indexData.length; tribase += 3) {
            int p = tribase;
            int q = tribase + 1;
            int r = tribase + 2;
            Vec3f.sub((float[])u, (int)0, (float[])coords, (int)this.indexData[q], (float[])coords, (int)this.indexData[p]);
            Vec3f.sub((float[])v, (int)0, (float[])coords, (int)this.indexData[r], (float[])coords, (int)this.indexData[p]);
            Vec3f.cross((float[])c, (float[])u, (float[])v);
            float len = Vec3f.length((float[])c);
            if (len > minSize) {
                newIndices[copyIndex] = this.indexData[p];
                newIndices[copyIndex + 1] = this.indexData[q];
                newIndices[copyIndex + 2] = this.indexData[r];
                copyIndex += 3;
                continue;
            }
            Console.println((String)("removing tri with size: " + len + " at indices " + p + ", " + q + ", " + r));
        }
        if (copyIndex != this.indexData.length) {
            Console.println((String)("cleanup removed " + (this.indexData.length - copyIndex) / 3 + " triangles"));
            this.indexData = new int[copyIndex];
            System.arraycopy(newIndices, 0, this.indexData, 0, copyIndex);
        }
    }

    public void triangulate() {
        if (!this.hasUnifiedIndexData()) {
            this.unifyIndices();
        }
        float[] coordData = null;
        for (VertexAttribute attr : this.attributeList) {
            if (!attr.getName().equals("mcPosition")) continue;
            coordData = attr.getVertexData();
            break;
        }
        if (coordData == null) {
            logger.warn("GMesh.triangulate: no Vertex coordinates defined");
            return;
        }
        if (this.indexData == null) {
            logger.warn("GMesh.triangulate: no (shared) indices defined");
            return;
        }
        if (this.vcounts == null) {
            logger.warn("GMesh.triangulate: no vcount (i.e. polygon count) data defined");
            return;
        }
        Triangulator triangulator = new Triangulator();
        this.indexData = triangulator.triangulate(coordData, 3, this.indexData, this.vcounts);
        this.vcounts = null;
        this.meshType = MeshType.Triangles;
    }

    public boolean hasUnifiedIndexData() {
        return this.unifiedIndexData;
    }

    public void unifyIndices() {
        if (this.hasUnifiedIndexData()) {
            return;
        }
        this.calculateTuples();
    }

    protected int[] calculateTuples() {
        int att;
        int nrOfAttributes = this.attributeList.size();
        int[][] map = new int[nrOfAttributes][];
        int indexLength = this.attributeList.get(0).getIndexData().length;
        for (VertexAttribute va : this.attributeList) {
            if (va.getIndexData().length == indexLength) continue;
            Console.println((String)"GMesh.unifyIndices:  attribute indices should have all equal size");
            throw new RuntimeException("GMesh.unifyIndices:  attribute indices should have all equal size");
        }
        this.indexData = new int[indexLength];
        int maxVertexDataSize = 0;
        for (VertexAttribute attr : this.attributeList) {
            if (attr.getVertexData().length <= maxVertexDataSize) continue;
            maxVertexDataSize = attr.getVertexData().length;
        }
        int tupleIndexSize = (int)(1.5 * (double)maxVertexDataSize);
        int nrOfTuples = 0;
        int[][] indices = new int[nrOfAttributes][];
        int vertexCoordIndex = 0;
        for (att = 0; att < nrOfAttributes; ++att) {
            VertexAttribute attr = this.attributeList.get(att);
            indices[att] = attr.getIndexData();
            map[att] = new int[tupleIndexSize];
            if (!attr.getName().equals("mcPosition")) continue;
            vertexCoordIndex = att;
        }
        for (int i = 0; i < indexLength; ++i) {
            int attr;
            if (nrOfTuples >= tupleIndexSize) {
                tupleIndexSize = 2 * tupleIndexSize;
                for (attr = 0; attr < nrOfAttributes; ++attr) {
                    int[] oldTupleIndices = map[attr];
                    map[attr] = new int[tupleIndexSize];
                    System.arraycopy(oldTupleIndices, 0, map, 0, nrOfTuples);
                }
            }
            for (attr = 0; attr < nrOfAttributes; ++attr) {
                map[attr][nrOfTuples] = indices[attr][i];
            }
            boolean isNew = true;
            int tuple = 0;
            for (tuple = 0; tuple < nrOfTuples; ++tuple) {
                boolean tupleDiffers = false;
                for (int attr2 = 0; attr2 < nrOfAttributes; ++attr2) {
                    boolean bl = tupleDiffers = map[attr2][tuple] != map[attr2][nrOfTuples];
                    if (tupleDiffers) break;
                }
                if (!(isNew = tupleDiffers)) break;
            }
            this.indexData[i] = tuple;
            if (isNew) {
                ++nrOfTuples;
            }
            this.unifiedIndexData = true;
        }
        this.nrOfVertices = nrOfTuples;
        for (att = 0; att < nrOfAttributes; ++att) {
            VertexAttribute attr = this.attributeList.get(att);
            attr.remapData(this.nrOfVertices, map[att]);
            attr.setIndexData(null);
        }
        if (this.morphAttributeLists != null) {
            for (ArrayList<VertexAttribute> atList : this.morphAttributeLists) {
                for (int att2 = 0; att2 < atList.size(); ++att2) {
                    VertexAttribute attr = atList.get(att2);
                    attr.remapData(this.nrOfVertices, map[att2]);
                    attr.setIndexData(null);
                }
            }
        }
        return map[vertexCoordIndex];
    }

    public static void showGMeshData(boolean show) {
        showGMeshData = show;
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        int itab = fmt.getIndentedTab();
        GMesh.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        GMesh.appendAttribute((StringBuilder)buf, (String)"meshType", (String)this.meshType.toString());
        if (this.nrOfVertices >= 0) {
            GMesh.appendAttribute((StringBuilder)buf, (String)"nrOfVertices", (int)this.nrOfVertices);
        }
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String mtype = this.getOptionalAttribute("meshType", attrMap);
        if (mtype != null) {
            this.meshType = MeshType.valueOf(mtype);
        }
        this.id = this.getOptionalAttribute("id", attrMap, "").intern();
        this.nrOfVertices = this.getOptionalIntAttribute("nrOfVertices", attrMap, -1);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.vcounts != null) {
            GMesh.appendIntArrayElement((StringBuilder)buf, (String)"vcounts", (int[])this.vcounts, (char)' ', (XMLFormatting)fmt, (int)30);
        }
        if (this.indexData != null) {
            GMesh.appendIntArrayElement((StringBuilder)buf, (String)"indices", (int[])this.indexData, (char)' ', (XMLFormatting)fmt, (int)30);
        }
        for (VertexAttribute attr : this.attributeList) {
            buf.append('\n');
            attr.appendXML(buf, fmt);
        }
        if (this.morphTargets != null) {
            GMesh.appendSTag((StringBuilder)buf, (String)"morphs", (XMLFormatting)fmt);
            fmt.indent();
            GMesh.appendStringArrayElement((StringBuilder)buf, (String)"morphtargets", (String[])this.morphTargets, (char)' ', (XMLFormatting)fmt, (int)15);
            for (int mt = 0; mt < this.morphTargets.length; ++mt) {
                GMesh.appendSTag((StringBuilder)buf, (String)"morphtarget", (XMLFormatting)fmt);
                ArrayList<VertexAttribute> mtAttributes = this.morphAttributeLists.get(mt);
                if (mtAttributes != null) {
                    fmt.indent();
                    for (VertexAttribute mtAttr : mtAttributes) {
                        buf.append('\n');
                        mtAttr.appendXML(buf, fmt);
                    }
                    fmt.unIndent();
                }
                GMesh.appendETag((StringBuilder)buf, (String)"morphtarget", (XMLFormatting)fmt);
            }
            GMesh.appendETag((StringBuilder)buf, (String)"morphs", (XMLFormatting)fmt.unIndent());
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("vcounts")) {
                this.vcounts = GMesh.decodeIntArrayElement((String)"vcounts", (XMLTokenizer)tokenizer);
                continue;
            }
            if (tag.equals("indices")) {
                this.indexData = GMesh.decodeIntArrayElement((String)"indices", (XMLTokenizer)tokenizer);
                continue;
            }
            if (tag.equals(VertexAttribute.xmlTag())) {
                this.addVertexAttribute(-1, new VertexAttribute(tokenizer));
                continue;
            }
            if (tag.equals("morphs")) {
                tokenizer.takeSTag("morphs");
                tag = tokenizer.getTagName();
                String[] morphTargets = GMesh.decodeStringArrayElement((String)"morphtargets", (XMLTokenizer)tokenizer);
                this.setMorphTargets(morphTargets);
                for (int mt = 0; mt < morphTargets.length; ++mt) {
                    tokenizer.takeSTag("morphtarget");
                    tag = tokenizer.getTagName();
                    if (tag.equals(VertexAttribute.xmlTag())) {
                        this.addVertexAttribute(mt, new VertexAttribute(tokenizer));
                    } else {
                        logger.warn(tokenizer.getErrorMessage("GMesh: VertexAttribute expected, skip: " + tokenizer.getTagName()));
                        tokenizer.skipTag();
                    }
                    tokenizer.takeETag("morphtarget");
                    tag = tokenizer.getTagName();
                }
                tokenizer.takeETag("morphs");
                continue;
            }
            logger.warn(tokenizer.getErrorMessage("GMesh: skip: " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        dataOut.writeUTF(this.id);
        dataOut.writeUTF(this.meshType.toString());
        dataOut.writeInt(this.nrOfVertices);
        BinUtil.writeIntArray((DataOutput)dataOut, (int[])this.vcounts);
        BinUtil.writeIntArray((DataOutput)dataOut, (int[])this.indexData);
        BinUtil.writeBinaryList((DataOutput)dataOut, this.attributeList);
        BinUtil.writeStringArray((DataOutput)dataOut, (String[])this.morphTargets);
        if (this.morphAttributeLists == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(this.morphAttributeLists.size());
            for (ArrayList<VertexAttribute> vaList : this.morphAttributeLists) {
                BinUtil.writeBinaryList((DataOutput)dataOut, vaList);
            }
        }
    }

    public void readBinary(DataInput dataIn) throws IOException {
        this.id = dataIn.readUTF().intern();
        this.meshType = MeshType.valueOf(dataIn.readUTF());
        this.nrOfVertices = dataIn.readInt();
        this.vcounts = BinUtil.readIntArray((DataInput)dataIn);
        this.indexData = BinUtil.readIntArray((DataInput)dataIn);
        this.attributeList = BinUtil.readBinaryList((DataInput)dataIn, VertexAttribute.class);
        this.morphTargets = BinUtil.readStringArray((DataInput)dataIn);
        int listSize = dataIn.readInt();
        if (listSize < 0) {
            this.morphAttributeLists = null;
        } else {
            this.morphAttributeLists = new ArrayList(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.morphAttributeLists.add(BinUtil.readBinaryList((DataInput)dataIn, VertexAttribute.class));
            }
        }
    }

    public static enum MeshType {
        Undefined,
        Triangles,
        Trifans,
        Tristrips,
        Polygons,
        Polylist;

    }
}

