/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLTexture;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;

public class GLMaterial
implements GLStateComponent {
    private String name = "";
    private static int scid = -1;
    private float[] emissiveColor = null;
    private float[] ambientColor = null;
    private float[] diffuseColor = null;
    private float[] specularColor = null;
    private float[] transparent = null;
    private float shininess = 1.0f;
    private GLTexture diffuseTexture;
    private GLTexture transparentTexture;
    private int diffuseTextureUnit;
    private int transparentTextureUnit;
    private float repeatS = 1.0f;
    private float repeatT = 1.0f;
    private float offsetS = 0.0f;
    private float offsetT = 0.0f;
    private boolean alphaBlendingEnabled = false;
    private int srcFactor;
    private int destFactor;
    private GLShader shader;
    private boolean debugMode = false;
    private static final int VEC4_SIZE = 4;
    private static boolean showDetail = true;

    public GLMaterial() {
        this("");
    }

    public GLMaterial(String name) {
        this.name = name;
        if (scid <= 0) {
            scid = GLState.createSCId();
        }
        this.init();
    }

    private void init() {
    }

    public void setGLShader(GLShader shader) {
        this.shader = shader;
        if (shader.getProgramName().equals("debug")) {
            this.debugMode = true;
        }
    }

    public boolean getAlphaBlendingEnabled() {
        return this.alphaBlendingEnabled;
    }

    public void setAlphaBlendingEnabled(boolean mode) {
        this.alphaBlendingEnabled = mode;
    }

    public void setBlendSrcFactor(int srcFactor) {
        this.srcFactor = srcFactor;
    }

    public void setBlendDestFactor(int destFactor) {
        this.destFactor = destFactor;
    }

    public void setEmissionColor(float[] color) {
        if (this.emissiveColor == null) {
            this.emissiveColor = new float[4];
        }
        int len = color.length;
        System.arraycopy(color, 0, this.emissiveColor, 0, len);
        if (len < 4) {
            this.emissiveColor[3] = 1.0f;
        }
    }

    public void setAmbientColor(float[] color) {
        if (this.ambientColor == null) {
            this.ambientColor = new float[4];
        }
        int len = color.length;
        System.arraycopy(color, 0, this.ambientColor, 0, len);
        if (len < 4) {
            this.ambientColor[3] = 1.0f;
        }
    }

    public void setDiffuseColor(float[] color) {
        if (this.diffuseColor == null) {
            this.diffuseColor = new float[4];
        }
        int len = color.length;
        System.arraycopy(color, 0, this.diffuseColor, 0, len);
        if (len < 4) {
            this.diffuseColor[3] = 1.0f;
        }
    }

    public void setSpecularColor(float[] color) {
        if (this.specularColor == null) {
            this.specularColor = new float[4];
        }
        int len = color.length;
        System.arraycopy(color, 0, this.specularColor, 0, len);
        if (len < 4) {
            this.specularColor[3] = 1.0f;
        }
    }

    public void setShininess(float shininess) {
        this.shininess = shininess;
    }

    public void setTransparentColor(float[] color) {
        if (this.transparent == null) {
            this.transparent = new float[4];
        }
        int len = color.length;
        System.arraycopy(color, 0, this.transparent, 0, len);
        if (len < 4) {
            this.transparent[3] = 1.0f;
        }
    }

    public void setTransparantTexture(GLTexture glTex, int texUnit) {
        this.transparentTexture = glTex;
        this.transparentTextureUnit = texUnit;
    }

    public void setDiffuseTexture(GLTexture glTex, int texUnit) {
        this.diffuseTexture = glTex;
        this.diffuseTextureUnit = texUnit;
    }

    public void setRepeatS(float r) {
        this.repeatS = r;
    }

    public float getRepeatS() {
        return this.repeatS;
    }

    public void setRepeatT(float r) {
        this.repeatT = r;
    }

    public float getRepeatT() {
        return this.repeatT;
    }

    public void setOffsetS(float r) {
        this.offsetS = r;
    }

    public float getOffsetS() {
        return this.offsetS;
    }

    public void setOffsetT(float r) {
        this.offsetT = r;
    }

    public float getOffsetT() {
        return this.offsetT;
    }

    @Override
    public final int getSCId() {
        return scid;
    }

    public String getName() {
        return this.name;
    }

    public final boolean eq(GLMaterial glm) {
        return false;
    }

    @Override
    public final void glInit(GLRenderContext gl) {
        if (this.shader != null) {
            if (this.emissiveColor != null) {
                this.shader.setValue("emissiveColor", this.emissiveColor);
            }
            if (this.ambientColor != null) {
                this.shader.setValue("ambientColor", this.ambientColor);
            }
            if (this.diffuseColor != null) {
                this.shader.setValue("diffuseColor", this.diffuseColor);
            }
            if (this.specularColor != null) {
                this.shader.setValue("specularColor", this.specularColor);
            }
            if ((double)this.shininess != 0.0) {
                this.shader.setValue("shininess", Float.valueOf(this.shininess));
            }
        }
        if (this.diffuseTexture != null) {
            this.diffuseTexture.glInit(gl);
            this.shader.setValue("TextureSampler", this.diffuseTextureUnit);
            this.shader.setValue("repeatS", Float.valueOf(this.repeatS));
            this.shader.setValue("repeatT", Float.valueOf(this.repeatT));
            this.shader.setValue("offsetS", Float.valueOf(this.offsetS));
            this.shader.setValue("offsetT", Float.valueOf(this.offsetT));
        }
        if (this.alphaBlendingEnabled) {
            if (this.transparentTexture != null) {
                this.transparentTexture.glInit(gl);
                this.shader.setValue("TransparentSampler", this.transparentTextureUnit);
            }
            if (this.transparent != null) {
                this.shader.setValue("transparentColor", this.transparent);
            }
        }
        if (this.shader != null) {
            this.shader.glInit(gl);
        }
    }

    @Override
    public final void glRender(GLRenderContext gl) {
        if (this.debugMode) {
            return;
        }
        if (this.alphaBlendingEnabled) {
            gl.glEnable(3042);
            gl.glBlendFunc(this.srcFactor, this.destFactor);
            gl.glDepthMask(false);
        } else {
            gl.glDisable(3042);
            gl.glDepthMask(true);
        }
        if (this.diffuseTexture != null) {
            this.diffuseTexture.glRender(gl);
        }
        if (this.transparentTexture != null) {
            this.transparentTexture.glRender(gl);
        }
        if (this.shader != null) {
            this.shader.glRender(gl);
        } else {
            gl.glUseProgram(0);
        }
    }

    private String fbts(float[] buf) {
        if (buf == null) {
            return "null";
        }
        return "[" + buf[0] + ", " + buf[1] + ", " + buf[2] + ", " + buf[3] + "]";
    }

    public static void setShowDetail(boolean show) {
        showDetail = show;
    }

    public boolean showDetail() {
        return showDetail;
    }

    public StringBuilder appendTo(StringBuilder buf, int tab) {
        GLUtil.appendSpaces(buf, tab);
        buf.append("GLMaterial " + this.getName() + "[");
        buf.append("shader=" + this.shader);
        if (this.showDetail()) {
            GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "emissiveColor=" + this.fbts(this.emissiveColor));
            GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "ambientColor=" + this.fbts(this.ambientColor));
            GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "diffuseColor=" + this.fbts(this.diffuseColor));
            GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "specularColor=" + this.fbts(this.specularColor));
            GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "shininess=" + this.shininess);
            if (this.diffuseTexture != null) {
                GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "diffuseTexture=" + this.diffuseTexture);
            }
            if (this.transparentTexture != null) {
                GLUtil.appendNLSpacesString(buf, tab + GLUtil.TAB, "transparentTexture=" + this.transparentTexture);
            }
            buf.append('\n');
        }
        buf.append(']');
        return buf;
    }

    public String toString() {
        StringBuilder buf = this.appendTo(new StringBuilder(), 0);
        return buf.toString();
    }
}

