/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.util.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GLScene
implements GLRenderObject {
    private String id = "";
    private ArrayList<VJoint> vjointRoots = new ArrayList();
    private ArrayList<GLSkinnedMesh> skinnedMeshList = new ArrayList();
    private GLRenderList shapeList = new GLRenderList();
    private static final float RADIUS = 0.005f;
    private static final int GRID = 16;
    private HashMap<String, Float> desiredMorphTargets = new HashMap();
    private static boolean showShapelist = true;
    private static boolean showSkinnedMeshes = true;
    private static boolean showScenegraph = true;
    private static int showScenegraphDepth = 10000;

    private GLScene() {
    }

    public GLScene(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addVJointRoot(VJoint root) {
        this.vjointRoots.add(root);
    }

    public List<VJoint> getVJointRoots() {
        return this.vjointRoots;
    }

    public VJoint getToplevelVJoint() {
        VJoint sceneRoot = new VJoint(this.getId());
        for (VJoint root : this.getVJointRoots()) {
            sceneRoot.addChild(root);
        }
        return sceneRoot;
    }

    public VJoint getBodyPartsVJoint(String execludedSkeletonRootSid) {
        VJoint sceneRoot = new VJoint(this.getId());
        for (VJoint root : this.getVJointRoots()) {
            Console.println((String)("getBodyPartsVJoint, root ids: " + root.getIds()));
            if (root.getId().equals(execludedSkeletonRootSid)) continue;
            sceneRoot.addChild(root);
        }
        return sceneRoot;
    }

    public VJoint getBodyPartsVJoint(List<String> includedIds) {
        VJoint sceneRoot = new VJoint(this.getId());
        for (VJoint root : this.getVJointRoots()) {
            Console.println((String)("getBodyPartsVJoint, root ids: " + root.getIds()));
            if (!includedIds.contains(root.getId())) continue;
            sceneRoot.addChild(root);
        }
        return sceneRoot;
    }

    public VJoint getVJoint(String partId) {
        for (VJoint vjrt : this.vjointRoots) {
            VJoint result = vjrt.getPart(partId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public GLRenderList getGLShapeList() {
        return this.shapeList;
    }

    public void prependGLShape(GLShape glShape) {
        this.shapeList.prepend(glShape);
    }

    public void addGLShapes(GLRenderList glShapes) {
        this.shapeList.addAll(glShapes);
    }

    public void addGLShape(GLShape glShape) {
        this.shapeList.add(glShape);
    }

    public void addSkinnedMeshes(List<GLSkinnedMesh> skinnedMeshes) {
        this.skinnedMeshList.addAll(skinnedMeshes);
    }

    public void addSkinnedMeshJointMarkers() {
        this.addSkinnedMeshJointMarkers(0.005f, 16);
    }

    public void addSkinnedMeshJointMarkers(float radius, int grid) {
        if (this.skinnedMeshList.size() > 0) {
            this.skinnedMeshList.get(0).addJointMarkers(radius, grid);
        }
    }

    public void sortGLShapeList() {
        int listSize = this.shapeList.size();
        GLRenderList newList = new GLRenderList(listSize);
        GLRenderList alphaList = new GLRenderList(listSize);
        for (int i = 0; i < listSize; ++i) {
            GLShape shape = (GLShape)this.shapeList.get(i);
            int stateListSize = shape.getStateList().size();
            GLMaterial glMat = null;
            for (int j = 0; j < stateListSize; ++j) {
                GLRenderObject sc = shape.getStateList().get(j);
                if (!(sc instanceof GLMaterial)) continue;
                glMat = (GLMaterial)sc;
                break;
            }
            if (glMat != null) {
                if (glMat.getAlphaBlendingEnabled()) {
                    alphaList.add(shape);
                    continue;
                }
                newList.add(shape);
                continue;
            }
            Console.println((String)" No GLMaterial found for GLShape");
        }
        Console.println((String)("listSizde=" + listSize + ", newListSize =" + newList.size() + ",  alphaListSize=" + alphaList.size()));
        newList.addAll(alphaList);
        this.shapeList = newList;
    }

    @Override
    public void glInit(GLRenderContext glc) {
        this.shapeList.glInit(glc);
    }

    public void deform() {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.deform();
        }
    }

    public GLSkinnedMesh getGLSkinnedMesh() {
        if (this.skinnedMeshList == null || this.skinnedMeshList.size() == 0) {
            return null;
        }
        return this.skinnedMeshList.get(0);
    }

    public GLSkinnedMesh getGLSkinnedMesh(int i) {
        if (this.skinnedMeshList == null || this.skinnedMeshList.size() == 0) {
            return null;
        }
        return this.skinnedMeshList.get(i);
    }

    public String[] getMorphTargets(int i) {
        if (i < 0 || i >= this.skinnedMeshList.size()) {
            return null;
        }
        return this.skinnedMeshList.get(i).getMorphTargets();
    }

    public List<GLSkinnedMesh> getGLSkinnedMeshList() {
        return this.skinnedMeshList;
    }

    public void morph(String targetName, float weight) {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.morph(targetName, weight);
        }
    }

    public void morph(String[] targetNames, float[] weights) {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.morph(targetNames, weights);
        }
    }

    public void morph(int[] targets, float[] weights) {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.morph(targets, weights);
        }
    }

    public void doMorph() {
        String[] desiredTargetNames = new String[this.desiredMorphTargets.size()];
        float[] desiredTargetWeights = new float[this.desiredMorphTargets.size()];
        int i = 0;
        Iterator<String> i$ = this.desiredMorphTargets.keySet().iterator();
        while (i$.hasNext()) {
            String targetName;
            desiredTargetNames[i] = targetName = i$.next();
            desiredTargetWeights[i] = this.desiredMorphTargets.get(targetName).floatValue();
            ++i;
        }
        this.morph(desiredTargetNames, desiredTargetWeights);
    }

    public void addMorphTargets(String[] targetNames, float[] weights) {
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = weights[i];
            Float fl = this.desiredMorphTargets.get(targetNames[i]);
            if (fl != null) {
                w += fl.floatValue();
            }
            if (w == 0.0f) {
                this.desiredMorphTargets.remove(targetNames[i]);
                continue;
            }
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    public void removeMorphTargets(String[] targetNames, float[] weights) {
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = -weights[i];
            Float fl = this.desiredMorphTargets.get(targetNames[i]);
            if (fl != null) {
                w += fl.floatValue();
            }
            if (w == 0.0f) {
                this.desiredMorphTargets.remove(targetNames[i]);
                continue;
            }
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    public void setMorphTargets(String[] targetNames, float[] weights) {
        this.desiredMorphTargets.clear();
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = weights[i];
            if (w == 0.0f) continue;
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
    }

    public static void setShowShapelist(boolean show) {
        showShapelist = show;
    }

    public boolean showShapelist() {
        return showShapelist;
    }

    public static void setShowSkinnedMeshes(boolean show) {
        showSkinnedMeshes = show;
    }

    public boolean showSkinnedMeshes() {
        return showSkinnedMeshes;
    }

    public static void setShowScenegraph(boolean show) {
        showScenegraph = show;
    }

    public boolean showScenegraph() {
        return showScenegraph;
    }

    public static void setShowScenegraphDepth(int depth) {
        showScenegraphDepth = depth;
    }

    public int showScenegraphDepth() {
        return showScenegraphDepth;
    }

    public StringBuilder appendTo(StringBuilder buf, int tab) {
        GLUtil.appendNLSpacesString(buf, tab, "GLScene " + this.id);
        if (this.showScenegraph()) {
            GLUtil.appendNLSpacesString(buf, tab, " -------------- Scenegraph -------------- ");
            for (VJoint root : this.vjointRoots) {
                GLUtil.appendNLSpacesString(buf, tab, " --- skeleton/scenegraph for " + root.getName() + "  ---\n");
                root.appendSkeleton(buf, tab + GLUtil.TAB, 1, this.showScenegraphDepth());
            }
        }
        if (this.showSkinnedMeshes()) {
            GLUtil.appendNLSpacesString(buf, tab, " -------------- SkinnedMeshes --------------");
            for (GLSkinnedMesh skinm : this.skinnedMeshList) {
                GLUtil.appendNLSpacesString(buf, tab, " --- SkinnedMesh ---\n");
                skinm.appendTo(buf, tab + GLUtil.TAB);
            }
        }
        if (this.showShapelist()) {
            GLUtil.appendNLSpacesString(buf, tab, " -------------- ShapeList -------------- ");
            this.shapeList.appendTo(buf, tab + GLUtil.TAB);
        }
        return buf;
    }

    public String toString() {
        StringBuilder buf = this.appendTo(new StringBuilder(), 0);
        return buf.toString();
    }
}

