/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.geometry.SphereGeometryFaceEditor;

public class GLNodeMarker
implements GLRenderObject {
    private static final float RADIUS = 0.005f;
    private static final int GRID = 8;
    private boolean visible = true;
    private GLRenderObject geometry;
    private float[] transformMatrix;
    private int index;
    private String name;

    public GLNodeMarker(int index, String name, float radius, int grid) {
        this.geometry = new SphereGeometryFaceEditor(radius, grid, grid);
        this.index = index;
        this.name = name;
    }

    public GLNodeMarker(int index, String name) {
        this(index, name, 0.005f, 8);
    }

    public synchronized void setVisible(boolean vis) {
        this.visible = vis;
    }

    public void linkToTransformMatrix(float[] trafo) {
        this.transformMatrix = trafo;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.geometry.glInit(gl);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (this.visible) {
            gl.glPushMatrix();
            gl.glMultTransposeMatrixf(this.transformMatrix);
            this.geometry.glRender(gl);
            gl.glPopMatrix();
        }
    }
}

