/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.geometry;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.math.Vec3f;

public class BoxGeometry
implements GLRenderObject {
    float[] vMin = new float[3];
    float[] vMax = new float[3];
    float[] origin = new float[3];

    public BoxGeometry(float xSize, float ySize, float zSize) {
        this.vMin[0] = -xSize * 0.5f;
        this.vMin[1] = -ySize * 0.5f;
        this.vMin[2] = -zSize * 0.5f;
        this.vMax[0] = xSize * 0.5f;
        this.vMax[1] = ySize * 0.5f;
        this.vMax[2] = zSize * 0.5f;
        Vec3f.set((float[])this.origin, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public BoxGeometry(float[] halfExtends) {
        this.setHalfExtends(halfExtends);
        Vec3f.set((float[])this.origin, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public BoxGeometry(float[] halfExtends, float[] orig) {
        this.setHalfExtends(halfExtends);
        Vec3f.set((float[])this.origin, (float[])orig);
    }

    public BoxGeometry(float[] halfExtends, float ox, float oy, float oz) {
        this.setHalfExtends(halfExtends);
        Vec3f.set((float[])this.origin, (float)ox, (float)oy, (float)oz);
    }

    public void setHalfExtends(float[] halfExtends) {
        Vec3f.set((float[])this.vMax, (float[])halfExtends);
        Vec3f.scale((float)-1.0f, (float[])this.vMin, (float[])halfExtends);
    }

    @Override
    public void glInit(GLRenderContext glc) {
    }

    @Override
    public void glRender(GLRenderContext gl) {
        gl.glTranslatef(this.origin[0], this.origin[1], this.origin[2]);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(this.vMin[0], this.vMin[1], this.vMax[2]);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(this.vMax[0], this.vMin[1], this.vMax[2]);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(this.vMax[0], this.vMax[1], this.vMax[2]);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(this.vMin[0], this.vMax[1], this.vMax[2]);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(this.vMin[0], this.vMin[1], this.vMin[2]);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(this.vMin[0], this.vMax[1], this.vMin[2]);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(this.vMax[0], this.vMax[1], this.vMin[2]);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(this.vMax[0], this.vMin[1], this.vMin[2]);
        gl.glNormal3f(-1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMax[1], this.vMin[2]);
        gl.glNormal3f(-1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMin[1], this.vMin[2]);
        gl.glNormal3f(-1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMin[1], this.vMax[2]);
        gl.glNormal3f(-1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMax[1], this.vMax[2]);
        gl.glNormal3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMax[1], this.vMin[2]);
        gl.glNormal3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMax[1], this.vMax[2]);
        gl.glNormal3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMin[1], this.vMax[2]);
        gl.glNormal3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMin[1], this.vMin[2]);
        gl.glNormal3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMax[1], this.vMax[2]);
        gl.glNormal3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMax[1], this.vMax[2]);
        gl.glNormal3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMax[1], this.vMin[2]);
        gl.glNormal3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMax[1], this.vMin[2]);
        gl.glNormal3f(0.0f, -1.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMin[1], this.vMax[2]);
        gl.glNormal3f(0.0f, -1.0f, 0.0f);
        gl.glVertex3f(this.vMin[0], this.vMin[1], this.vMin[2]);
        gl.glNormal3f(0.0f, -1.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMin[1], this.vMin[2]);
        gl.glNormal3f(0.0f, -1.0f, 0.0f);
        gl.glVertex3f(this.vMax[0], this.vMin[1], this.vMax[2]);
        gl.glEnd();
    }
}

