/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLBinding;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.graphics.util.BufferUtil;
import java.nio.FloatBuffer;

public class GLVertexAttribute {
    private String attributeName;
    private int attributeIndex = -1;
    private int texUnit = -1;
    private FloatBuffer vertexDataBuffer;
    private int floatBufferSize;
    private int byteBufferSize;
    private int attribSize;
    private boolean bufferModified;
    private int bufferOffset;
    private int nrOfVertices;

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendTo(buf, 0);
        return buf.toString();
    }

    public StringBuilder appendTo(StringBuilder buf, int tab) {
        GLUtil.appendSpacesString(buf, tab, "GLVertexAttribute \"");
        buf.append(this.attributeName);
        buf.append('\"');
        buf.append(" nrOfVertices=");
        buf.append(this.nrOfVertices);
        float[] vdata = this.getVertexData(null);
        int dataSize = vdata.length;
        int lineSize = 30;
        for (int i = 0; i < dataSize; ++i) {
            if (i % lineSize == 0) {
                GLUtil.appendNLSpaces(buf, tab);
                buf.append(String.format("%6d", i));
                buf.append(":  ");
            }
            buf.append(String.format("%6.3f", Float.valueOf(vdata[i])));
            buf.append("  ");
        }
        return buf;
    }

    public GLVertexAttribute(String attrName, float[] vertexData, int attribSize, int nrOfVertices, int texUnit) {
        this.attributeName = attrName;
        this.attribSize = attribSize;
        this.setTexUnit(texUnit);
        this.nrOfVertices = nrOfVertices;
        this.floatBufferSize = nrOfVertices * attribSize;
        this.byteBufferSize = 4 * this.floatBufferSize;
        this.vertexDataBuffer = BufferUtil.directFloatBuffer(this.floatBufferSize);
        this.setVertexData(vertexData);
    }

    public GLVertexAttribute(VertexAttribute va) {
        this(va.getName(), va.getVertexData(), va.getAttributeValueSize(), va.getNrOfValues(), 1);
    }

    public void setTexUnit(int texUnit) {
        this.texUnit = texUnit;
    }

    public int getTexUnit() {
        return this.texUnit;
    }

    public String getName() {
        return this.attributeName;
    }

    public int getNrOfVertices() {
        return this.nrOfVertices;
    }

    public int getByteBufferSize() {
        return this.byteBufferSize;
    }

    public void setArrayBufferOffset(int offset) {
        this.bufferOffset = offset;
    }

    public void setVertexData(float[] vertexData) {
        this.vertexDataBuffer.clear();
        this.vertexDataBuffer.put(vertexData, 0, this.floatBufferSize);
        this.bufferModified = true;
    }

    public float[] getVertexData(float[] vertexData) {
        if (vertexData == null) {
            vertexData = new float[this.floatBufferSize];
        }
        this.vertexDataBuffer.rewind();
        this.vertexDataBuffer.get(vertexData, 0, this.floatBufferSize);
        return vertexData;
    }

    public int setAttributeIndex(GLBinding gl, int prog) {
        this.attributeIndex = gl.glGetAttribLocation(prog, this.attributeName);
        return this.attributeIndex;
    }

    public void glInit(GLBinding gl) {
    }

    public void glRender(GLBinding gl) {
        if (this.attributeIndex < 0) {
            return;
        }
        if (this.bufferModified) {
            this.vertexDataBuffer.rewind();
            gl.glBufferSubData(34962, this.bufferOffset, this.byteBufferSize, this.vertexDataBuffer);
            this.bufferModified = false;
        }
        gl.glVertexAttribPointer(this.attributeIndex, this.attribSize, 5126, false, 0, this.bufferOffset);
        gl.glEnableVertexAttribArray(this.attributeIndex);
    }
}

