/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl;

import hmi.graphics.opengl.GLBasicMesh;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.graphics.opengl.GLUtil;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.util.Console;

public class GLRenderList
implements GLRenderObject {
    private static final GLRenderObject[] EMPTYLIST = new GLRenderObject[0];
    private GLRenderObject[] renderList = EMPTYLIST;
    private int arraySize = 0;
    private int size = 0;
    private static final int DEFAULTSIZE = 8;

    public GLRenderList() {
    }

    public GLRenderList(int capacity) {
        this.ensureArraySize(capacity);
    }

    private void ensureArraySize(int requestedSize) {
        if (requestedSize <= this.arraySize) {
            return;
        }
        if (this.arraySize == 0) {
            this.arraySize = 8;
        }
        while (this.arraySize < requestedSize) {
            this.arraySize *= 2;
        }
        GLRenderObject[] newRenderList = new GLRenderObject[this.arraySize];
        System.arraycopy(this.renderList, 0, newRenderList, 0, this.size);
        this.renderList = newRenderList;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(GLRenderObject ro) {
        this.ensureArraySize(this.size + 1);
        this.renderList[this.size] = ro;
        ++this.size;
    }

    public void addAll(GLRenderList rlist) {
        if (rlist == null) {
            return;
        }
        this.ensureArraySize(this.size + rlist.size);
        for (int i = 0; i < rlist.size; ++i) {
            this.renderList[this.size + i] = rlist.renderList[i];
        }
        this.size += rlist.size;
    }

    public void prepend(GLRenderObject ro) {
        this.ensureArraySize(this.size + 1);
        for (int i = this.size; i > 0; --i) {
            this.renderList[i] = this.renderList[i - 1];
        }
        this.renderList[0] = ro;
        ++this.size;
    }

    public GLRenderObject get(int i) {
        if (i < 0 || i >= this.size) {
            return null;
        }
        return this.renderList[i];
    }

    @Override
    public void glInit(GLRenderContext glc) {
        for (int i = 0; i < this.size; ++i) {
            this.renderList[i].glInit(glc);
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
        for (int i = 0; i < this.size; ++i) {
            this.renderList[i].glRender(glc);
        }
    }

    public StringBuilder appendTo(StringBuilder buf, int tab) {
        GLUtil.appendSpacesString(buf, tab, "GLRenderList (");
        for (int i = 0; i < this.size; ++i) {
            buf.append("\n");
            GLRenderObject robj = this.renderList[i];
            if (robj instanceof GLRenderList) {
                ((GLRenderList)robj).appendTo(buf, tab + GLUtil.TAB);
                continue;
            }
            if (robj instanceof GLShape) {
                ((GLShape)robj).appendTo(buf, tab + GLUtil.TAB);
                continue;
            }
            if (robj instanceof GLMaterial) {
                ((GLMaterial)robj).appendTo(buf, tab + GLUtil.TAB);
                continue;
            }
            if (robj instanceof GLSkinnedMesh) {
                ((GLSkinnedMesh)robj).appendTo(buf, tab + GLUtil.TAB);
                continue;
            }
            if (robj instanceof GLBasicMesh) {
                ((GLBasicMesh)robj).appendTo(buf, tab + GLUtil.TAB);
                continue;
            }
            Console.println((String)("GLrenderList.appendTo, unknown class:" + robj.getClass().getName()));
            buf.append(robj.toString());
        }
        buf.append("\n");
        GLUtil.appendSpaces(buf, tab);
        buf.append(")");
        return buf;
    }

    public String toString() {
        StringBuilder buf = this.appendTo(new StringBuilder(), 0);
        return buf.toString();
    }
}

