/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.LookAt;
import hmi.graphics.collada.Matrix;
import hmi.graphics.collada.Rotate;
import hmi.graphics.collada.Scale;
import hmi.graphics.collada.Skew;
import hmi.graphics.collada.TransformNode;
import hmi.graphics.collada.Translate;
import hmi.graphics.scenegraph.GNode;
import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import java.util.List;

public final class TransformTranslator {
    private static float[] m = Mat4f.getMat4f();
    private static float[] t = Vec3f.getVec3f();
    private static float[] q = Quat4f.getQuat4f();
    private static float[] svec = Vec3f.getVec3f();
    private static float[] smat = Mat3f.getMat3f();
    private static int stage = 0;
    private static final int STAGE0 = 0;
    private static final int STAGE1 = 1;
    private static final int STAGE2 = 2;
    private static final int STAGE3 = 3;
    private static final int STAGE4 = 4;
    private static final int STAGE5 = 5;

    private TransformTranslator() {
    }

    private static void setMatrix() {
        if (stage <= 3) {
            Mat4f.setFromTRSVec3f((float[])m, (float[])t, (float[])q, (float[])svec);
        } else {
            Mat4f.setFromTRSMat3f((float[])m, (float[])t, (float[])q, (float[])smat);
        }
    }

    public static void setTransform(List<TransformNode> transforms, GNode gnode) {
        Mat4f.setIdentity((float[])m);
        Vec3f.set((float[])t, (float)0.0f, (float)0.0f, (float)0.0f);
        Quat4f.setIdentity((float[])q);
        Vec3f.set((float[])svec, (float)1.0f, (float)1.0f, (float)1.0f);
        Mat3f.setIdentity((float[])smat);
        stage = 0;
        if (transforms != null) {
            for (TransformNode transform : transforms) {
                if (transform instanceof Translate) {
                    Translate tr = (Translate)transform;
                    switch (stage) {
                        case 0: {
                            Vec3f.set((float[])t, (float[])tr.getTranslationVec3f());
                            break;
                        }
                        case 1: {
                            Vec3f.add((float[])t, (float[])tr.getTranslationVec3f());
                            break;
                        }
                        case 2: {
                            Vec3f.add((float[])t, (float[])Quat4f.transformVec3f((float[])q, (float[])tr.getTranslationVec3f()));
                            break;
                        }
                        case 3: 
                        case 4: {
                            TransformTranslator.setMatrix();
                            Mat4f.mul((float[])m, (float[])tr.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 5: {
                            Mat4f.mul((float[])m, (float[])tr.getMat4f());
                        }
                    }
                    continue;
                }
                if (transform instanceof Rotate) {
                    Rotate rt = (Rotate)transform;
                    switch (stage) {
                        case 0: 
                        case 1: {
                            Quat4f.set((float[])q, (float[])rt.getRotationQuat4f());
                            stage = 2;
                            break;
                        }
                        case 2: {
                            Quat4f.mul((float[])q, (float[])rt.getRotationQuat4f());
                            break;
                        }
                        case 3: 
                        case 4: {
                            TransformTranslator.setMatrix();
                            Mat4f.mul((float[])m, (float[])rt.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 5: {
                            Mat4f.mul((float[])m, (float[])rt.getMat4f());
                        }
                    }
                    continue;
                }
                if (transform instanceof Scale) {
                    Scale sc = (Scale)transform;
                    switch (stage) {
                        case 0: 
                        case 1: 
                        case 2: {
                            Vec3f.set((float[])svec, (float[])sc.getScaleVec3f());
                            stage = 3;
                            break;
                        }
                        case 3: {
                            Vec3f.pmul((float[])svec, (float[])sc.getScaleVec3f());
                            break;
                        }
                        case 4: {
                            TransformTranslator.setMatrix();
                            Mat4f.mul((float[])m, (float[])sc.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 5: {
                            Mat4f.mul((float[])m, (float[])sc.getMat4f());
                        }
                    }
                    continue;
                }
                if (transform instanceof Skew) {
                    Skew sk = (Skew)transform;
                    switch (stage) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            TransformTranslator.setMatrix();
                            Mat4f.mul((float[])m, (float[])sk.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 5: {
                            Mat4f.mul((float[])m, (float[])sk.getMat4f());
                        }
                    }
                    continue;
                }
                if (transform instanceof Matrix) {
                    Matrix mt = (Matrix)transform;
                    switch (stage) {
                        case 0: {
                            Mat4f.set((float[])m, (float[])mt.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            TransformTranslator.setMatrix();
                            Mat4f.mul((float[])m, (float[])mt.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 5: {
                            Mat4f.mul((float[])m, (float[])mt.getMat4f());
                        }
                    }
                    continue;
                }
                if (transform instanceof LookAt) {
                    LookAt lk = (LookAt)transform;
                    switch (stage) {
                        case 0: {
                            Vec3f.set((float[])t, (float[])lk.getLookAtTranslation3f());
                            Quat4f.set((float[])q, (float[])lk.getLookAtRotation4f());
                            stage = 2;
                            break;
                        }
                        case 1: {
                            Vec3f.add((float[])t, (float[])lk.getLookAtTranslation3f());
                            Quat4f.set((float[])q, (float[])lk.getLookAtRotation4f());
                            stage = 2;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            TransformTranslator.setMatrix();
                            Mat4f.mul((float[])m, (float[])lk.getMat4f());
                            stage = 5;
                            break;
                        }
                        case 5: {
                            Mat4f.mul((float[])m, (float[])lk.getMat4f());
                        }
                    }
                    continue;
                }
                transform.getCollada().warning("Translator: unknown transform type, ignored");
            }
        }
        if (stage < 5) {
            gnode.setTranslation(t);
            gnode.setRotation(q);
            if (stage == 3) {
                gnode.setScale(svec);
            }
            if (stage == 4) {
                gnode.setSkewMatrix(smat);
            }
        } else {
            gnode.setLocalTransform(m);
        }
    }
}

