/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.scenegraph.VertexWeights;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public final class GSkin
extends XMLStructureAdapter {
    private String[] jointNames;
    private float[] bindShapeMatrix;
    private float[] invBindMatrices;
    private int[] jointIndices;
    private float[] jointWeights;
    private int[] vcount;
    private static final int JOINTNAMESPERLINE = 20;
    private static final String XMLTAG = "GSkin";

    private GSkin() {
    }

    public GSkin(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public void setJointIndices(int[] jointIndices) {
        this.jointIndices = jointIndices;
    }

    public int[] getJointIndices() {
        return this.jointIndices;
    }

    public void setJointWeights(float[] jointWeights) {
        this.jointWeights = jointWeights;
    }

    public float[] getJointWeights() {
        return this.jointWeights;
    }

    public void setVCount(int[] vcount) {
        this.vcount = vcount;
    }

    public int[] getVCount() {
        return this.vcount;
    }

    public VertexWeights createVertexWeights() {
        int[] vc = Arrays.copyOf(this.vcount, this.vcount.length);
        int[] ji = Arrays.copyOf(this.jointIndices, this.jointIndices.length);
        float[] jw = Arrays.copyOf(this.jointWeights, this.jointWeights.length);
        return new VertexWeights(vc, ji, jw);
    }

    public void setBindShapeMatrix(float[] m4x4) {
        this.bindShapeMatrix = m4x4;
    }

    public float[] getBindShapeMatrix() {
        return this.bindShapeMatrix;
    }

    public void setJointNames(String[] jointNames) {
        this.jointNames = jointNames;
    }

    public String[] getJointNames() {
        return this.jointNames;
    }

    public void setInvBindMatrices(float[] invBindMatrices) {
        this.invBindMatrices = invBindMatrices;
    }

    public float[] getInvBindMatrices() {
        return this.invBindMatrices;
    }

    public String toString() {
        return this.toXMLString();
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        fmt.indent();
        buf.append('\n');
        GSkin.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
        GSkin.appendAttribute((StringBuilder)buf, (String)"joints", (String[])this.jointNames, (char)' ', (XMLFormatting)fmt, (int)20);
        buf.append('\n');
        GSkin.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
        GSkin.appendAttribute((StringBuilder)buf, (String)"invbindmatrices", (float[])this.invBindMatrices, (char)' ', (XMLFormatting)fmt, (int)16);
        fmt.unIndent();
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String jointNameAttr = this.getRequiredAttribute("joints", attrMap, tokenizer);
        this.jointNames = GSkin.decodeStringArray((String)jointNameAttr);
        String invBindMatricesAttr = this.getRequiredAttribute("invbindmatrices", attrMap, tokenizer);
        this.invBindMatrices = GSkin.decodeFloatArray((String)invBindMatricesAttr);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

