/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada.scenegraph;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.InstanceController;
import hmi.graphics.collada.InstanceGeometry;
import hmi.graphics.collada.Node;
import hmi.graphics.collada.Scene;
import hmi.graphics.collada.TransformNode;
import hmi.graphics.collada.VisualScene;
import hmi.graphics.collada.scenegraph.InstanceControllerTranslator;
import hmi.graphics.collada.scenegraph.InstanceGeometryTranslator;
import hmi.graphics.collada.scenegraph.TransformTranslator;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.util.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class ColladaTranslator {
    private ColladaTranslator() {
    }

    public static GScene colladaToGSkinnedMeshScene(Collada collada) {
        Scene scene = collada.getScene();
        if (scene == null) {
            throw new RuntimeException("ColladaTranslator.colladaToGScene: Collada document without scene.");
        }
        GScene gscene = ColladaTranslator.colladaSceneToGScene(collada, scene);
        gscene.normalizeMeshes();
        gscene.collectSkinnedMeshes();
        gscene.resolveSkinnedMeshJoints();
        Map<Object, Object> renaming = new HashMap();
        String upAxis = collada.getAsset().getUpAxis();
        if (upAxis.equals("X_UP")) {
            gscene.rotate(0.0f, 0.0f, 1.0f, 1.5707964f);
        } else if (!upAxis.equals("Y_UP") && !upAxis.equals("")) {
            if (upAxis.equals("Z_UP")) {
                gscene.rotate(1.0f, 0.0f, 0.0f, -1.5707964f);
            } else {
                Console.println((String)("ColladaTranslator: Collada Asset with unknown or incorrect UP axis: " + upAxis));
            }
        }
        float scale = collada.getAsset().getUnitMeter();
        if (scale != 1.0f) {
            gscene.scale(scale);
        }
        gscene.adjustBindPoses();
        String renamingList = collada.getRenamingList();
        renaming = renamingList != null ? ColladaTranslator.getColladaRenaming(renamingList, gscene.getRootNodes()) : new HashMap();
        gscene.renameJoints(renaming);
        return gscene;
    }

    private static GScene colladaSceneToGScene(Collada collada, Scene scene) {
        if (scene.getInstanceVisualScene() == null || scene.getInstanceVisualScene().getURL() == null) {
            throw new RuntimeException("Translator.colladaSceneToGNode: Collada document with null visual_scene.");
        }
        String url = scene.getInstanceVisualScene().getURL();
        VisualScene vscene = (VisualScene)((Object)collada.getLibItem(collada.getLibrariesVisualScenes(), url));
        if (vscene == null) {
            throw new RuntimeException("ColladaTranslator.colladaSceneToGNode: visual_scene " + url + " could not be found.");
        }
        GScene gscene = new GScene(url);
        ArrayList<Node> rootNodes = vscene.getNodes();
        for (Node rootNode : rootNodes) {
            GNode gRootNode = ColladaTranslator.colladaNodeToGNode(collada, rootNode);
            gscene.addRootNode(gRootNode);
        }
        return gscene;
    }

    private static GNode colladaNodeToGNode(Collada collada, Node node) {
        if (node == null) {
            return null;
        }
        GNode gnode = new GNode();
        String id = node.getId();
        String sid = node.getSid();
        String name = node.getName();
        if (id == null) {
            id = name;
        }
        gnode.setId(id);
        gnode.setSid(sid);
        gnode.setName(name);
        String type = node.getType();
        if (type != null) {
            gnode.setType(type);
        }
        List<TransformNode> transformList = node.getTransforms();
        TransformTranslator.setTransform(transformList, gnode);
        List<InstanceGeometry> instanceGeometries = node.getInstanceGeometries();
        InstanceGeometryTranslator.addGShapes(collada, instanceGeometries, gnode);
        List<InstanceController> instanceControllers = node.getInstanceControllers();
        if (!instanceControllers.isEmpty()) {
            ArrayList<InstanceController> instanceSkinControllers = new ArrayList<InstanceController>(instanceControllers.size());
            for (InstanceController ic : instanceControllers) {
                if (ic.getController().getSkin() == null) continue;
                instanceSkinControllers.add(ic);
            }
            InstanceControllerTranslator.addInstanceControllerGShapes(collada, instanceSkinControllers, gnode);
            ArrayList<InstanceController> instanceMorphControllers = new ArrayList<InstanceController>(1);
            for (InstanceController ic : instanceControllers) {
                if (ic.getController().getMorph() == null) continue;
                instanceMorphControllers.add(ic);
            }
            if (!instanceMorphControllers.isEmpty()) {
                Console.println((String)"ColladaTranslator: cannot handle instance morph controller");
            }
        }
        for (Node childNode : node.getNodes()) {
            GNode gchild = ColladaTranslator.colladaNodeToGNode(collada, childNode);
            gnode.addChildNode(gchild);
        }
        return gnode;
    }

    private static Map<String, String> getColladaRenaming(String renamingList, List<GNode> rootNodes) {
        StringTokenizer tok = new StringTokenizer(renamingList);
        int numTokens = tok.countTokens();
        if (numTokens % 2 != 0) {
            throw new IllegalArgumentException("Collada translator: joint renaming list with odd number of Strings");
        }
        int numPairs = numTokens / 2;
        Pattern[] patterns = new Pattern[numPairs];
        String[] replacements = new String[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            patterns[i] = Pattern.compile(tok.nextToken());
            replacements[i] = tok.nextToken();
        }
        HashMap<String, String> renaming = new HashMap<String, String>();
        block1: for (int i = 0; i < patterns.length; ++i) {
            for (GNode rnode : rootNodes) {
                GNode nod = rnode.getPartByNamePattern(patterns[i]);
                if (nod == null) continue;
                String sid = nod.getSid();
                if (sid == null) {
                    sid = nod.getName();
                }
                if (sid == null) continue block1;
                renaming.put(sid, replacements[i]);
                continue block1;
            }
        }
        return renaming;
    }
}

