/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Source;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Vertices
extends ColladaElement {
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<Extra> extras;
    private static final String XMLTAG = "vertices";

    public Vertices() {
    }

    public Vertices(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public ArrayList<Input> getInputs() {
        return this.inputs;
    }

    public Source getSource(String semantic) {
        for (Input inp : this.inputs) {
            if (!inp.getSemantic().equals(semantic)) continue;
            Source source = this.getCollada().getSource(inp.getSource());
            if (source == null) {
                throw new RuntimeException("Vertices.getSource: Input with unresolved Source");
            }
            return source;
        }
        throw new RuntimeException("Vertices.getSource: No Input defined for Semantic: " + semantic);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Vertices.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.inputs);
        Vertices.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                Input inp = new Input(this.getCollada(), tokenizer);
                if (inp.getSemantic() == null) {
                    throw new RuntimeException("Vertices Input without semantic attribute");
                }
                if (inp.getOffset() >= 0) {
                    throw new RuntimeException("Vertices Input cannot have offset attributes");
                }
                this.inputs.add(inp);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Vertices: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.inputs);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

