/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ConnectParam;
import hmi.graphics.collada.ParamArray;
import hmi.graphics.collada.Setparam;
import hmi.graphics.collada.ValueType;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Usertype
extends ColladaElement {
    private ArrayList<ParamArray> arrays = new ArrayList();
    private ArrayList<ValueType> valueTypes = new ArrayList();
    private ArrayList<ConnectParam> connectParams = new ArrayList();
    private ArrayList<Usertype> usertypes = new ArrayList();
    private ArrayList<Setparam> setparams = new ArrayList();
    private static final String XMLTAG = "usertype";

    public Usertype() {
    }

    public Usertype(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Usertype.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        Usertype.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.arrays);
        Usertype.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.valueTypes);
        Usertype.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.connectParams);
        Usertype.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.usertypes);
        Usertype.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.setparams);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(ConnectParam.xmlTag())) {
                this.connectParams.add(new ConnectParam(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Usertype.xmlTag())) {
                this.usertypes.add(new Usertype(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Setparam.xmlTag())) {
                this.setparams.add(new Setparam(this.getCollada(), tokenizer));
                continue;
            }
            if (ValueType.hasTag(tag)) {
                this.valueTypes.add(new ValueType(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Usertype: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.connectParams);
        this.addColladaNodes(this.usertypes);
        this.addColladaNodes(this.setparams);
        this.addColladaNodes(this.valueTypes);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

