/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.SamplerState;
import hmi.graphics.collada.Surface;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class TextureUnit
extends ColladaElement {
    private Surface surface;
    private SamplerState samplerState;
    private String texcoord;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "texture_unit";

    public TextureUnit() {
    }

    public TextureUnit(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.surface);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.samplerState);
        TextureUnit.appendTextElement((StringBuilder)buf, (String)"texcoord", (String)this.texcoord, (XMLFormatting)fmt);
        TextureUnit.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Surface.xmlTag())) {
                this.surface = new Surface(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(SamplerState.xmlTag())) {
                this.samplerState = new SamplerState(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("texcoord")) {
                this.texcoord = tokenizer.takeTextElement("texcoord");
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("TextureUnit: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.surface);
        this.addColladaNode(this.samplerState);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

