/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Accessor;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class TechniqueCommonSource
extends ColladaElement {
    private Accessor accessor;
    private static final String XMLTAG = "technique_common";

    public TechniqueCommonSource() {
    }

    public TechniqueCommonSource(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String prof = this.getOptionalAttribute("profile", attrMap);
        if (prof != null && !prof.equals("COMMON")) {
            this.getCollada().warning("common_profile with profile attribute: " + prof + "  (ignored)");
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.accessor);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Accessor.xmlTag())) {
                this.accessor = new Accessor(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("TechniqueCommonSource: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.accessor);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

