/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Directional;
import hmi.graphics.collada.Orthographic;
import hmi.graphics.collada.Perspective;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class TechniqueCommon
extends ColladaElement {
    private Orthographic orthographic;
    private Perspective perspective;
    private Directional directional;
    private static final String XMLTAG = "technique_common";

    public TechniqueCommon() {
    }

    public TechniqueCommon(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String prof = this.getOptionalAttribute("profile", attrMap);
        if (prof != null && !prof.equals("COMMON")) {
            this.getCollada().warning("common_profile with profile attribute: " + prof + "  (ignored)");
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.orthographic);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.perspective);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.directional);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Orthographic.xmlTag())) {
                this.orthographic = new Orthographic(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Perspective.xmlTag())) {
                this.perspective = new Perspective(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Directional.xmlTag())) {
                this.directional = new Directional(this.getCollada(), tokenizer);
                continue;
            }
            super.decodeContent(tokenizer);
            this.getCollada().warning(tokenizer.getErrorMessage("TechniqueCommon: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.orthographic);
        this.addColladaNode(this.perspective);
        this.addColladaNode(this.directional);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

