/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ControlVertices;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Source;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Spline
extends ColladaElement {
    private String closed;
    private ArrayList<Source> sources = new ArrayList();
    private ControlVertices controlVertices;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "spline";

    public Spline() {
    }

    public Spline(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Spline.appendAttribute((StringBuilder)buf, (String)"closed", (String)this.closed);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.closed = this.getOptionalAttribute("closed", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Spline.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.sources);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.controlVertices);
        Spline.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Source.xmlTag())) {
                this.sources.add(new Source(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(ControlVertices.xmlTag())) {
                this.controlVertices = new ControlVertices(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Spline: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.sources);
        this.addColladaNode(this.controlVertices);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

