/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.TransformNode;
import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Vec3f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Skew
extends TransformNode {
    private float angle;
    private float[] rvec = Vec3f.getVec3f((float)0.0f, (float)1.0f, (float)0.0f);
    private float[] tvec = Vec3f.getVec3f((float)0.0f, (float)1.0f, (float)0.0f);
    private float[] mat3f;
    private static final String XMLTAG = "skew";

    public Skew() {
    }

    public Skew(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public float[] getMat4f() {
        if (super.getMat4f() == null) {
            this.setMat4f(Mat4f.getSkewMatrix((float)this.angle, (float[])this.rvec, (float[])this.tvec));
        }
        return super.getMat4f();
    }

    public float[] getSkewMat3f() {
        if (this.mat3f == null) {
            this.mat3f = Mat3f.getSkewMatrix((float)this.angle, (float[])this.rvec, (float[])this.tvec);
        }
        return this.mat3f;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Skew.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        buf.append(this.angle);
        Skew.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        Skew.appendFloats((StringBuilder)buf, (float[])this.rvec, (char)' ', (XMLFormatting)fmt, (int)3);
        Skew.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        Skew.appendFloats((StringBuilder)buf, (float[])this.tvec, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        float[] angleRvecTvec = new float[7];
        Skew.decodeFloatArray((String)tokenizer.takeCharData(), (float[])angleRvecTvec);
        this.angle = angleRvecTvec[0];
        Vec3f.set((float[])this.rvec, (int)0, (float[])angleRvecTvec, (int)1);
        Vec3f.set((float[])this.tvec, (int)0, (float[])angleRvecTvec, (int)4);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

