/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.TransformNode;
import hmi.math.Mat4f;
import hmi.math.Vec3f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Scale
extends TransformNode {
    private float[] scaleVec = Vec3f.getVec3f((float)1.0f, (float)1.0f, (float)1.0f);
    private static final String XMLTAG = "scale";

    public Scale() {
    }

    public Scale(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public float[] getMat4f() {
        if (super.getMat4f() == null) {
            this.setMat4f(Mat4f.getScalingMatrix((float[])this.scaleVec));
        }
        return super.getMat4f();
    }

    public float[] getScaleVec3f() {
        return this.scaleVec;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Scale.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        Scale.appendFloats((StringBuilder)buf, (float[])this.scaleVec, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        Scale.decodeFloatArray((String)tokenizer.takeCharData(), (float[])this.scaleVec);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

