/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.BorderColor;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Source;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class SamplerDEPTH
extends ColladaElement {
    private Source source;
    private String wrapS;
    private String wrapT;
    private String wrapP;
    private String minfilter;
    private String magfilter;
    private String mipfilter;
    private BorderColor borderColor;
    private int mipmapMaxlevel;
    private float mipmapBias;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "samplerDEPTH";

    public SamplerDEPTH() {
    }

    public SamplerDEPTH(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.source);
        SamplerDEPTH.appendTextElement((StringBuilder)buf, (String)"wrap_s", (String)this.wrapS, (XMLFormatting)fmt);
        SamplerDEPTH.appendTextElement((StringBuilder)buf, (String)"wrap_t", (String)this.wrapT, (XMLFormatting)fmt);
        SamplerDEPTH.appendTextElement((StringBuilder)buf, (String)"wrap_p", (String)this.wrapP, (XMLFormatting)fmt);
        SamplerDEPTH.appendTextElement((StringBuilder)buf, (String)"minfilter", (String)this.minfilter, (XMLFormatting)fmt);
        SamplerDEPTH.appendTextElement((StringBuilder)buf, (String)"mipfilter", (String)this.mipfilter, (XMLFormatting)fmt);
        SamplerDEPTH.appendTextElement((StringBuilder)buf, (String)"magfilter", (String)this.magfilter, (XMLFormatting)fmt);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.borderColor);
        SamplerDEPTH.appendIntElement((StringBuilder)buf, (String)"mipmap_maxlevel", (int)this.mipmapMaxlevel, (XMLFormatting)fmt);
        SamplerDEPTH.appendFloatElement((StringBuilder)buf, (String)"mipmap_bias", (float)this.mipmapBias, (XMLFormatting)fmt);
        SamplerDEPTH.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals("Source.XMLTag")) {
                this.source = new Source(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("wrap_s")) {
                this.wrapS = tokenizer.takeTextElement("wrap_s");
                continue;
            }
            if (tag.equals("wrap_t")) {
                this.wrapT = tokenizer.takeTextElement("wrap_t");
                continue;
            }
            if (tag.equals("wrap_p")) {
                this.wrapP = tokenizer.takeTextElement("wrap_p");
                continue;
            }
            if (tag.equals("minfilter")) {
                this.minfilter = tokenizer.takeTextElement("minfilter");
                continue;
            }
            if (tag.equals("magfilter")) {
                this.magfilter = tokenizer.takeTextElement("magfilter");
                continue;
            }
            if (tag.equals("mipfilter")) {
                this.mipfilter = tokenizer.takeTextElement("mipfilter");
                continue;
            }
            if (tag.equals("border_color")) {
                this.borderColor = new BorderColor(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("mipmap_maxlevel")) {
                this.mipmapMaxlevel = tokenizer.takeIntElement("mipmap_maxlevel");
                continue;
            }
            if (tag.equals("mipmap_bias")) {
                this.mipmapBias = tokenizer.takeFloatElement("mipmap_bias");
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("SamplerDEPTH: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.source);
        this.addColladaNode(this.borderColor);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

