/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ParamArray;
import hmi.graphics.collada.Sampler1D;
import hmi.graphics.collada.Sampler2D;
import hmi.graphics.collada.Sampler3D;
import hmi.graphics.collada.Surface;
import hmi.graphics.collada.Usertype;
import hmi.graphics.collada.ValueType;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class ParamValue
extends ColladaElement {
    private ValueType valueType;
    private Usertype usertype;
    private ParamArray array;
    private Surface surface;
    private Sampler1D sampler1D;
    private Sampler2D sampler2D;
    private Sampler3D sampler3D;
    private Type type;
    private static final String XMLTAG = "paramvalue";

    public ParamValue() {
    }

    public ParamValue(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Sampler1D getSampler1D() {
        return this.sampler1D;
    }

    public Sampler2D getSampler2D() {
        return this.sampler2D;
    }

    public Sampler3D getSampler3D() {
        return this.sampler3D;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public Usertype getUsertype() {
        return this.usertype;
    }

    public ParamArray getParamArray() {
        return this.array;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.valueType);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.usertype);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.array);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.surface);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.sampler1D);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.sampler2D);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.sampler3D);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Usertype.xmlTag())) {
                this.usertype = new Usertype(this.getCollada(), tokenizer);
                this.type = Type.UserType;
                continue;
            }
            if (tag.equals(ParamArray.xmlTag())) {
                this.array = new ParamArray(this.getCollada(), tokenizer);
                this.type = Type.ParamArray;
                continue;
            }
            if (ValueType.hasTag(tag)) {
                this.valueType = new ValueType(this.getCollada(), tokenizer);
                this.type = Type.ValueType;
                continue;
            }
            if (tag.equals(Surface.xmlTag())) {
                this.surface = new Surface(this.getCollada(), tokenizer);
                this.type = Type.Surface;
                continue;
            }
            if (tag.equals(Sampler1D.xmlTag())) {
                this.sampler1D = new Sampler1D(this.getCollada(), tokenizer);
                this.type = Type.Sampler1D;
                continue;
            }
            if (tag.equals(Sampler2D.xmlTag())) {
                this.sampler2D = new Sampler2D(this.getCollada(), tokenizer);
                this.type = Type.Sampler2D;
                continue;
            }
            if (tag.equals(Sampler3D.xmlTag())) {
                this.sampler3D = new Sampler3D(this.getCollada(), tokenizer);
                this.type = Type.Sampler3D;
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Setparam: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.usertype);
        this.addColladaNode(this.array);
        this.addColladaNode(this.valueType);
        this.addColladaNode(this.surface);
        this.addColladaNode(this.sampler1D);
        this.addColladaNode(this.sampler2D);
        this.addColladaNode(this.sampler3D);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public static enum Type {
        ValueType,
        UserType,
        ParamArray,
        Surface,
        Sampler1D,
        Sampler2D,
        Sampler3D;

    }
}

