/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Geometry;
import hmi.graphics.collada.Source;
import hmi.graphics.collada.Targets;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Morph
extends ColladaElement {
    private String source;
    private String method;
    private ArrayList<Source> sources = new ArrayList();
    private Targets targets;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "morph";

    public Morph() {
    }

    public Morph(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public Geometry getBaseGeometry() {
        if (this.getCollada() == null || this.getCollada().getLibrariesGeometries() == null) {
            return null;
        }
        return (Geometry)((Object)this.getCollada().getLibItem(this.getCollada().getLibrariesGeometries(), this.source));
    }

    public Geometry[] getTargetGeometries() {
        if (this.getCollada() == null || this.getCollada().getLibrariesGeometries() == null) {
            return null;
        }
        String[] targetIds = this.getMorphTargetIds();
        if (targetIds == null) {
            return null;
        }
        Geometry[] result = new Geometry[targetIds.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Geometry)((Object)this.getCollada().getLibItem(this.getCollada().getLibrariesGeometries(), targetIds[i]));
        }
        return result;
    }

    public String getMorphBaseId() {
        return this.urlToId(this.source);
    }

    public String getMorphMethod() {
        return this.method;
    }

    public String[] getMorphTargetIds() {
        if (this.targets == null) {
            this.getCollada().warning("Morph without targets");
            return new String[0];
        }
        String srcId = this.urlToId(this.targets.getMorphTargetSource());
        for (Source src : this.sources) {
            if (!src.getId().equals(srcId)) continue;
            src.resolve();
            return src.getHomogeneousIDREFData();
        }
        return new String[0];
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Morph.appendAttribute((StringBuilder)buf, (String)"source", (String)this.source);
        Morph.appendAttribute((StringBuilder)buf, (String)"method", (String)this.method);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.source = this.getRequiredAttribute("source", attrMap, tokenizer);
        this.method = this.getOptionalAttribute("method", attrMap, "NORMALIZED");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Morph.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.sources);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.targets);
        Morph.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Source.xmlTag())) {
                this.sources.add(new Source(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Targets.xmlTag())) {
                this.targets = new Targets(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Morph: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.sources);
        this.addColladaNode(this.targets);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

