/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.PolyList;
import hmi.graphics.collada.Polygons;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.graphics.collada.Source;
import hmi.graphics.collada.Triangles;
import hmi.graphics.collada.Vertices;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Mesh
extends ColladaElement {
    private ArrayList<Source> sources = new ArrayList();
    private Vertices vertices;
    private static final int LISTSIZE = 4;
    private ArrayList<PrimitiveMeshElement> primitiveMeshElements = new ArrayList(4);
    private static final String XMLTAG = "mesh";

    public Mesh() {
    }

    public Mesh(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public void reportNode(String reportType) {
        if (!reportType.startsWith("Mesh")) {
            return;
        }
        this.getCollada().warning(this.toString());
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public Vertices getVertices() {
        return this.vertices;
    }

    public List<PrimitiveMeshElement> getPrimitiveMeshElements() {
        return this.primitiveMeshElements;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Mesh.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.sources);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.vertices);
        Mesh.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.primitiveMeshElements);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Source.xmlTag())) {
                this.sources.add(new Source(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Vertices.xmlTag())) {
                this.vertices = new Vertices(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Polygons.xmlTag())) {
                Polygons polygons = new Polygons(this.getCollada(), tokenizer);
                this.primitiveMeshElements.add(polygons);
                continue;
            }
            if (tag.equals(PolyList.xmlTag())) {
                PolyList polylist = new PolyList(this.getCollada(), tokenizer);
                this.primitiveMeshElements.add(polylist);
                continue;
            }
            if (tag.equals(Triangles.xmlTag())) {
                Triangles triangles = new Triangles(this.getCollada(), tokenizer);
                this.primitiveMeshElements.add(triangles);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Mesh: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        if (this.vertices == null) {
            this.vertices = new Vertices();
        }
        this.addColladaNodes(this.sources);
        this.addColladaNode(this.vertices);
        this.addColladaNodes(this.primitiveMeshElements);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public static enum MeshType {
        Undefined,
        Triangles,
        Trifans,
        Tristrips,
        Polygons,
        Polylist,
        Lines,
        Linestrips;

    }
}

