/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class MayaProfile
extends ColladaElement {
    private int mirrorU = 0;
    private int mirrorV = 0;
    private int wrapU = 1;
    private int wrapV = 1;
    private float repeatU = 1.0f;
    private float repeatV = 1.0f;
    private float offsetU = 0.0f;
    private float offsetV = 0.0f;
    private float rotateUV = 0.0f;
    private String preInfinity;
    private String postInfinity;

    public MayaProfile() {
    }

    public MayaProfile(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.decodeContent(tokenizer);
    }

    public float getMirrorU() {
        return this.mirrorU;
    }

    public float getMirrorV() {
        return this.mirrorV;
    }

    public float getWrapU() {
        return this.wrapU;
    }

    public float getWrapV() {
        return this.wrapV;
    }

    public float getRepeatU() {
        return this.repeatU;
    }

    public float getRepeatV() {
        return this.repeatV;
    }

    public float getOffsetU() {
        return this.offsetU;
    }

    public float getOffsetV() {
        return this.offsetV;
    }

    public float getRotateUV() {
        return this.rotateUV;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        MayaProfile.appendOptionalIntElement((StringBuilder)buf, (String)"mirrorU", (int)this.mirrorU, (int)0, (XMLFormatting)fmt);
        MayaProfile.appendOptionalIntElement((StringBuilder)buf, (String)"mirrorV", (int)this.mirrorV, (int)0, (XMLFormatting)fmt);
        MayaProfile.appendOptionalIntElement((StringBuilder)buf, (String)"wrapU", (int)this.wrapU, (int)0, (XMLFormatting)fmt);
        MayaProfile.appendOptionalIntElement((StringBuilder)buf, (String)"wrapV", (int)this.wrapV, (int)0, (XMLFormatting)fmt);
        MayaProfile.appendOptionalFloatElement((StringBuilder)buf, (String)"repeatU", (float)this.repeatU, (float)0.0f, (XMLFormatting)fmt);
        MayaProfile.appendOptionalFloatElement((StringBuilder)buf, (String)"repeatV", (float)this.repeatV, (float)0.0f, (XMLFormatting)fmt);
        MayaProfile.appendOptionalFloatElement((StringBuilder)buf, (String)"offsetU", (float)this.offsetU, (float)0.0f, (XMLFormatting)fmt);
        MayaProfile.appendOptionalFloatElement((StringBuilder)buf, (String)"offsetV", (float)this.offsetV, (float)0.0f, (XMLFormatting)fmt);
        MayaProfile.appendOptionalFloatElement((StringBuilder)buf, (String)"rotateUV", (float)this.rotateUV, (float)0.0f, (XMLFormatting)fmt);
        MayaProfile.appendTextElement((StringBuilder)buf, (String)"pre_infinity", (String)this.preInfinity, (XMLFormatting)fmt);
        MayaProfile.appendTextElement((StringBuilder)buf, (String)"post_infinity", (String)this.postInfinity, (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("mirrorU")) {
                this.mirrorU = tokenizer.takeIntElement("mirrorU");
                continue;
            }
            if (tag.equals("mirrorV")) {
                this.mirrorV = tokenizer.takeIntElement("mirrorV");
                continue;
            }
            if (tag.equals("wrapU")) {
                this.wrapU = tokenizer.takeIntElement("wrapU");
                continue;
            }
            if (tag.equals("wrapV")) {
                this.wrapV = tokenizer.takeIntElement("wrapV");
                continue;
            }
            if (tag.equals("repeatU")) {
                this.repeatU = tokenizer.takeFloatElement("repeatU");
                continue;
            }
            if (tag.equals("repeatV")) {
                this.repeatV = tokenizer.takeFloatElement("repeatV");
                continue;
            }
            if (tag.equals("offsetU")) {
                this.offsetU = tokenizer.takeFloatElement("offsetU");
                continue;
            }
            if (tag.equals("offsetV")) {
                this.offsetV = tokenizer.takeFloatElement("offsetV");
                continue;
            }
            if (tag.equals("rotateUV")) {
                this.rotateUV = tokenizer.takeFloatElement("rotateUV");
                continue;
            }
            if (tag.equals("pre_infinity")) {
                this.preInfinity = tokenizer.takeTextElement("pre_infinity");
                continue;
            }
            if (tag.equals("post_infinity")) {
                this.postInfinity = tokenizer.takeTextElement("post_infinity");
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Technique, MAYA profile, skipping: " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }
}

