/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Max3DFrameRate;
import hmi.graphics.collada.Max3DHelper;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;

public class Max3DProfile
extends ColladaElement {
    private Max3DFrameRate max3dFrameRate;
    private Max3DHelper max3dHelper;
    private float amount = -1.0f;
    private int faceted = -1;
    private int doubleSided = -1;
    private int wireframe = -1;
    private int faceMap = -1;

    public Max3DProfile() {
    }

    public Max3DProfile(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.decodeContent(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.max3dFrameRate);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.max3dHelper);
        Max3DProfile.appendOptionalFloatElement((StringBuilder)buf, (String)"amount", (float)this.amount, (float)-1.0f, (XMLFormatting)fmt);
        Max3DProfile.appendOptionalIntElement((StringBuilder)buf, (String)"faceted", (int)this.faceted, (int)-1, (XMLFormatting)fmt);
        Max3DProfile.appendOptionalIntElement((StringBuilder)buf, (String)"double_sided", (int)this.doubleSided, (int)-1, (XMLFormatting)fmt);
        Max3DProfile.appendOptionalIntElement((StringBuilder)buf, (String)"wireframe", (int)this.wireframe, (int)-1, (XMLFormatting)fmt);
        Max3DProfile.appendOptionalIntElement((StringBuilder)buf, (String)"face_map", (int)this.faceMap, (int)-1, (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Max3DFrameRate.xmlTag())) {
                this.max3dFrameRate = new Max3DFrameRate(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Max3DHelper.xmlTag())) {
                this.max3dHelper = new Max3DHelper(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("amount")) {
                this.amount = tokenizer.takeFloatElement("amount");
                continue;
            }
            if (tag.equals("faceted")) {
                this.faceted = tokenizer.takeIntElement("faceted");
                continue;
            }
            if (tag.equals("double_sided")) {
                this.doubleSided = tokenizer.takeIntElement("double_sided");
                continue;
            }
            if (tag.equals("wireframe")) {
                this.wireframe = tokenizer.takeIntElement("wireframe");
                continue;
            }
            if (tag.equals("face_map")) {
                this.faceMap = tokenizer.takeIntElement("face_map");
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Technique, MAX3D profile, skipping: " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.max3dFrameRate);
        this.addColladaNode(this.max3dHelper);
    }
}

