/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Effect;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.InstanceEffect;
import hmi.graphics.collada.Setparam;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Material
extends ColladaElement {
    private Asset asset;
    private InstanceEffect instanceEffect;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "material";

    public Material() {
    }

    public Material(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public Effect getEffect() {
        if (this.instanceEffect == null) {
            return null;
        }
        String url = this.instanceEffect.getURL();
        if (url == null) {
            return null;
        }
        return (Effect)((Object)this.getCollada().getLibItem(this.getCollada().getLibrariesEffects(), url));
    }

    public List<Setparam> getSetparamList() {
        if (this.instanceEffect == null) {
            return null;
        }
        return this.instanceEffect.getSetParamList();
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.instanceEffect);
        Material.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(InstanceEffect.xmlTag())) {
                this.instanceEffect = new InstanceEffect(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Material: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNode(this.instanceEffect);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

