/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Mesh;
import hmi.graphics.collada.P;
import hmi.graphics.collada.PrimitiveMeshElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class LineStrips
extends PrimitiveMeshElement {
    private ArrayList<P> plist = new ArrayList();
    private static final String XMLTAG = "linestrips";

    public LineStrips() {
        this.setMeshType(Mesh.MeshType.Linestrips);
    }

    public LineStrips(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
        this.setMeshType(Mesh.MeshType.Linestrips);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        LineStrips.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getInputs());
        LineStrips.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.plist);
        LineStrips.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.getExtras());
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                Input inp = new Input(this.getCollada(), tokenizer);
                this.getInputs().add(inp);
                if (inp.getOffset() <= this.getMaxOffset()) continue;
                this.setMaxOffset(inp.getOffset());
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.getExtras().add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(P.xmlTag())) {
                this.plist.add(new P(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("LineStrips: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.getInputs());
        this.addColladaNodes(this.plist);
        this.addColladaNodes(this.getExtras());
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

