/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Input;
import hmi.graphics.collada.Source;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Joints
extends ColladaElement {
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private String[] jointSIDs = null;
    private float[] invBindMatrices = null;
    private String jointSourceId = null;
    private String invbindmatrixSourceId = null;
    private static final String XMLTAG = "joints";

    public Joints() {
    }

    public Joints(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public void resolve() {
        for (Input inp : this.inputs) {
            if (inp.getSemantic().equals("JOINT")) {
                this.jointSourceId = this.urlToId(inp.getSource());
            }
            if (!inp.getSemantic().equals("INV_BIND_MATRIX")) continue;
            this.invbindmatrixSourceId = this.urlToId(inp.getSource());
        }
        if (this.jointSourceId == null) {
            throw new RuntimeException("<joints> element: no <input> with JOINT semantic specified");
        }
        Source jointSource = this.getCollada().getSource(this.jointSourceId);
        this.jointSIDs = jointSource.getHomogeneousNameData();
        if (this.invbindmatrixSourceId == null) {
            throw new RuntimeException("<joints> element: no <input> with INV_BIND_MATRIX semantic specified");
        }
        Source invBindMatrixSource = this.getCollada().getSource(this.invbindmatrixSourceId);
        this.invBindMatrices = invBindMatrixSource.getHomogeneousFloatData();
    }

    public String[] getJointSIDs() {
        if (this.jointSIDs == null) {
            this.resolve();
        }
        return this.jointSIDs;
    }

    public float[] getInvBindMatrices() {
        if (this.invBindMatrices == null) {
            this.resolve();
        }
        return this.invBindMatrices;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Joints.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.inputs);
        Joints.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Input.xmlTag())) {
                this.inputs.add(new Input(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Joints: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.inputs);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

