/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class IntArray
extends ColladaElement {
    private static final int DEFAULT_MIN_INCLUSIVE = Integer.MIN_VALUE;
    private static final int DEFAULT_MAX_INCLUSIVE = Integer.MAX_VALUE;
    private static final int NR_OF_INTS_PER_LINE = 3;
    private int count;
    private int minInclusive = Integer.MIN_VALUE;
    private int maxInclusive = Integer.MAX_VALUE;
    private int[] ints;
    private static final String XMLTAG = "int_array";

    public IntArray() {
    }

    public IntArray(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        IntArray.appendAttribute((StringBuilder)buf, (String)"count", (int)this.count);
        if (this.minInclusive != Integer.MIN_VALUE) {
            IntArray.appendAttribute((StringBuilder)buf, (String)"minInclusive", (int)this.minInclusive);
        }
        if (this.maxInclusive != Integer.MAX_VALUE) {
            IntArray.appendAttribute((StringBuilder)buf, (String)"maxInclusive", (int)this.maxInclusive);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        this.minInclusive = this.getOptionalIntAttribute("minInclusive", attrMap, Integer.MIN_VALUE);
        this.maxInclusive = this.getOptionalIntAttribute("maxInclusive", attrMap, Integer.MAX_VALUE);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        IntArray.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        IntArray.appendInts((StringBuilder)buf, (int[])this.ints, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        this.ints = new int[this.count];
        IntArray.decodeIntArray((String)tokenizer.takeCharData(), (int[])this.ints);
        this.getCollada().addIntArray(this.getId(), this.ints);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

