/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.BindMaterial;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Controller;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Skeleton;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InstanceController
extends ColladaElement {
    private String url;
    private BindMaterial bindMaterial;
    private ArrayList<Skeleton> skeletons = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "instance_controller";

    public InstanceController() {
    }

    public InstanceController(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getURL() {
        return this.url;
    }

    public Controller getController() {
        if (this.getCollada() == null || this.getCollada().getLibrariesControllers() == null) {
            return null;
        }
        return (Controller)((Object)this.getCollada().getLibItem(this.getCollada().getLibrariesControllers(), this.url));
    }

    public BindMaterial getBindMaterial() {
        return this.bindMaterial;
    }

    public List<Skeleton> getSkeletons() {
        return this.skeletons;
    }

    public String[] getSkeletonIds() {
        String[] result = new String[this.skeletons.size()];
        int i = 0;
        for (Skeleton skel : this.skeletons) {
            result[i] = skel.getId();
            ++i;
        }
        return result;
    }

    public List<String> getSkeletonURLs() {
        ArrayList<String> result = new ArrayList<String>(this.skeletons.size());
        for (Skeleton skel : this.skeletons) {
            result.add(skel.getURL());
        }
        return result;
    }

    public boolean hasContent() {
        return this.bindMaterial != null || this.skeletons.size() > 0 || this.extras.size() > 0;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        InstanceController.appendAttribute((StringBuilder)buf, (String)"url", (String)this.url);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.url = this.getRequiredAttribute("url", attrMap, tokenizer);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        InstanceController.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.skeletons);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.bindMaterial);
        InstanceController.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(BindMaterial.xmlTag())) {
                this.bindMaterial = new BindMaterial(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Skeleton.xmlTag())) {
                this.skeletons.add(new Skeleton(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("InstanceController: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.bindMaterial);
        this.addColladaNodes(this.skeletons);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

