/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class Input
extends ColladaElement {
    private String semantic;
    private String sourceURL;
    private int offset = -1;
    private int set = -1;
    private static final String XMLTAG = "input";

    public Input() {
    }

    public Input(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getSemantic() {
        return this.semantic;
    }

    public String getSource() {
        return this.sourceURL;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSet() {
        return this.set;
    }

    public boolean hasContent() {
        return false;
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Input.appendAttribute((StringBuilder)buf, (String)"semantic", (String)this.semantic);
        Input.appendAttribute((StringBuilder)buf, (String)"source", (String)this.sourceURL);
        if (this.offset >= 0) {
            Input.appendAttribute((StringBuilder)buf, (String)"offset", (int)this.offset);
        }
        if (this.set >= 0) {
            Input.appendAttribute((StringBuilder)buf, (String)"set", (int)this.set);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.semantic = this.getRequiredAttribute("semantic", attrMap, tokenizer);
        this.sourceURL = this.getRequiredAttribute("source", attrMap, tokenizer);
        this.offset = this.getOptionalIntAttribute("offset", attrMap, -1);
        this.set = this.getOptionalIntAttribute("set", attrMap, -1);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

