/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class FormatHint
extends ColladaElement {
    private String channels;
    private String range;
    private String precision;
    private String option;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "format_hint";

    public FormatHint() {
    }

    public FormatHint(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        FormatHint.appendTextElement((StringBuilder)buf, (String)"channels", (String)this.channels, (XMLFormatting)fmt);
        FormatHint.appendTextElement((StringBuilder)buf, (String)"range", (String)this.range, (XMLFormatting)fmt);
        FormatHint.appendTextElement((StringBuilder)buf, (String)"precision", (String)this.precision, (XMLFormatting)fmt);
        FormatHint.appendTextElement((StringBuilder)buf, (String)"option", (String)this.option, (XMLFormatting)fmt);
        FormatHint.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals("channels")) {
                this.channels = tokenizer.takeTextElement("channels");
                continue;
            }
            if (tag.equals("range")) {
                this.range = tokenizer.takeTextElement("range");
                continue;
            }
            if (tag.equals("precision")) {
                this.precision = tokenizer.takeTextElement("precision");
                continue;
            }
            if (tag.equals("option")) {
                this.option = tokenizer.takeTextElement("option");
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("FormatHint: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

