/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class FloatArray
extends ColladaElement {
    public static final int DEFAULT_DIGITS = 6;
    public static final int DEFAULT_MAGNITUDE = 38;
    private static final int NR_OF_FLOATS_PER_LINE = 3;
    private int count;
    private int digits = 6;
    private int magnitude = 38;
    private float[] floats;
    private static final String XMLTAG = "float_array";

    public FloatArray() {
    }

    public FloatArray(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        FloatArray.appendAttribute((StringBuilder)buf, (String)"count", (int)this.count);
        if (this.digits != 6) {
            FloatArray.appendAttribute((StringBuilder)buf, (String)"digits", (int)this.digits);
        }
        if (this.magnitude != 38) {
            FloatArray.appendAttribute((StringBuilder)buf, (String)"magnitude", (int)this.magnitude);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.count = this.getRequiredIntAttribute("count", attrMap, tokenizer);
        this.digits = this.getOptionalIntAttribute("digits", attrMap, 6);
        this.magnitude = this.getOptionalIntAttribute("magnitude", attrMap, 38);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        FloatArray.appendNewLine((StringBuilder)buf, (XMLFormatting)fmt);
        FloatArray.appendFloats((StringBuilder)buf, (float[])this.floats, (char)' ', (XMLFormatting)fmt, (int)3);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        this.floats = new float[this.count];
        FloatArray.decodeFloatArray((String)tokenizer.takeCharData(), (float[])this.floats);
        this.getCollada().addFloatArray(this.getId(), this.floats);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

