/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ElckerlycProfile;
import hmi.graphics.collada.FColladaProfile;
import hmi.graphics.collada.Max3DProfile;
import hmi.graphics.collada.MayaProfile;
import hmi.graphics.collada.RenderMonkeyProfile;
import hmi.graphics.collada.TechniqueCore;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Extra
extends ColladaElement {
    private String type;
    private Asset asset;
    private List<TechniqueCore> techniques = new ArrayList<TechniqueCore>(4);
    private Max3DProfile max3DProfile;
    private FColladaProfile fcolladaProfile;
    private MayaProfile mayaProfile;
    private RenderMonkeyProfile rendermonkeyProfile;
    private ElckerlycProfile elckerlycProfile;
    private static final String XMLTAG = "extra";

    public Extra() {
    }

    public Extra(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public Max3DProfile getMax3DProfile() {
        return this.max3DProfile;
    }

    public FColladaProfile getFColladaProfile() {
        return this.fcolladaProfile;
    }

    public MayaProfile getMayaProfile() {
        return this.mayaProfile;
    }

    public RenderMonkeyProfile getRenderMonkeyProfileProfile() {
        return this.rendermonkeyProfile;
    }

    public ElckerlycProfile getElckerlycProfile() {
        return this.elckerlycProfile;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        for (TechniqueCore technique : this.techniques) {
            this.appendXMLStructure(buf, fmt, (XMLStructure)technique);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(TechniqueCore.xmlTag())) {
                TechniqueCore technique = new TechniqueCore(this.getCollada(), tokenizer);
                this.techniques.add(technique);
                if (technique.getProfile().equals("MAX3D")) {
                    this.max3DProfile = technique.getMax3DProfile();
                    continue;
                }
                if (technique.getProfile().equals("MAYA")) {
                    this.mayaProfile = technique.getMayaProfile();
                    continue;
                }
                if (technique.getProfile().equals("FCOLLADA")) {
                    this.fcolladaProfile = technique.getFColladaProfile();
                    continue;
                }
                if (technique.getProfile().equals("RenderMonkey")) {
                    this.rendermonkeyProfile = technique.getRendermonkeyProfile();
                    continue;
                }
                if (!technique.getProfile().equals("Elckerlyc")) continue;
                this.elckerlycProfile = technique.getElckerlycProfile();
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Extra: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        Extra.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.type = this.getOptionalAttribute("type", attrMap);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

