/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.ColladaFloat;
import hmi.graphics.collada.Param;
import hmi.graphics.collada.ValueType;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Map;

public class CommonFloatOrParamType
extends ColladaElement {
    private ColladaFloat colladaFloat;
    private Param param;

    public CommonFloatOrParamType() {
    }

    public CommonFloatOrParamType(Collada collada) {
        super(collada);
    }

    public String getParamRef() {
        if (this.param == null) {
            return null;
        }
        return this.param.getRef();
    }

    public float getFloat() {
        if (this.colladaFloat == null) {
            return 0.0f;
        }
        return this.colladaFloat.getFloatVal();
    }

    public float getFloat(Map<String, ValueType> paramDefs) {
        if (this.colladaFloat != null) {
            return this.colladaFloat.getFloatVal();
        }
        if (this.param == null) {
            this.getCollada().warning("Collada float: no value nor parameter defined");
            return 0.0f;
        }
        ValueType vt = paramDefs.get(this.param.getRef());
        if (vt.getBaseType() != ValueType.BaseType.Float || vt.getSize() != 1) {
            this.getCollada().warning("Collada Float parameter with wrong base type or wrong size:" + (Object)((Object)vt.getBaseType()) + vt.getSize());
            return 0.0f;
        }
        return vt.getFloats()[0];
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.colladaFloat);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String tag = tokenizer.getTagName();
        if (tag.equals(ColladaFloat.xmlTag())) {
            this.colladaFloat = new ColladaFloat(this.getCollada(), tokenizer);
        } else if (tag.equals(Param.xmlTag())) {
            this.param = new Param(this.getCollada(), tokenizer);
        } else {
            this.getCollada().warning(tokenizer.getErrorMessage("CommonFloatOrParamType: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.colladaFloat);
        this.addColladaNode(this.param);
    }
}

