/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.CommonColor;
import hmi.graphics.collada.CommonTexture;
import hmi.graphics.collada.Param;
import hmi.graphics.collada.ParamValue;
import hmi.graphics.collada.ValueType;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.Map;

public class CommonColorOrTextureType
extends ColladaElement {
    private CommonColor color;
    private Param param;
    private CommonTexture texture;
    private static final int BASETYPESIZE = 4;

    public CommonColorOrTextureType() {
    }

    public CommonColorOrTextureType(Collada collada) {
        super(collada);
    }

    public String getParamRef() {
        if (this.param == null) {
            return null;
        }
        return this.param.getRef();
    }

    public float[] getColor4f() {
        if (this.color == null) {
            return null;
        }
        return this.color.getVec();
    }

    public float[] getColor4f(Map<String, ParamValue> paramDefs) {
        if (this.color != null) {
            return this.color.getVec();
        }
        if (this.param == null || paramDefs == null) {
            return null;
        }
        ParamValue val = paramDefs.get(this.param.getRef());
        if (val.getType() != ParamValue.Type.ValueType) {
            this.getCollada().warning("Shader color parameter with wrong type:" + (Object)((Object)val.getType()));
            return null;
        }
        ValueType vt = val.getValueType();
        if (vt == null || vt.getBaseType() != ValueType.BaseType.Float || vt.getSize() != 4) {
            this.getCollada().warning("Shader color parameter with wrong base type or size:" + (Object)((Object)vt.getBaseType()) + vt.getSize());
            return null;
        }
        return vt.getFloats();
    }

    public CommonTexture getTexture() {
        return this.texture;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.color);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.param);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.texture);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        String tag = tokenizer.getTagName();
        if (tag.equals(CommonColor.xmlTag())) {
            this.color = new CommonColor(this.getCollada(), tokenizer);
        } else if (tag.equals(CommonTexture.xmlTag())) {
            this.texture = new CommonTexture(this.getCollada(), tokenizer);
        } else if (tag.equals(Param.xmlTag())) {
            this.param = new Param(this.getCollada(), tokenizer);
        } else {
            this.getCollada().warning(tokenizer.getErrorMessage("CommonColorOrTextureType: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.color);
        this.addColladaNode(this.texture);
        this.addColladaNode(this.param);
    }
}

