/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Data;
import hmi.graphics.collada.Extra;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ColladaImage
extends ColladaElement {
    private String format;
    private int height = -1;
    private int width = -1;
    private int depth = 1;
    private Asset asset;
    private Data data;
    private String initFrom;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "image";

    public ColladaImage() {
    }

    public ColladaImage(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public String getInitFrom() {
        return this.initFrom;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.data);
        ColladaImage.appendTextElement((StringBuilder)buf, (String)"init_from", (String)this.initFrom, (XMLFormatting)fmt);
        ColladaImage.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Data.xmlTag())) {
                this.data = new Data(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals("init_from")) {
                this.initFrom = tokenizer.takeTextElement("init_from");
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("ColladaImage: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNode(this.data);
        this.addColladaNodes(this.extras);
    }

    @Override
    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        ColladaImage.appendAttribute((StringBuilder)buf, (String)"format", (String)this.format);
        if (this.height >= 0) {
            ColladaImage.appendAttribute((StringBuilder)buf, (String)"height", (int)this.height);
        }
        if (this.width >= 0) {
            ColladaImage.appendAttribute((StringBuilder)buf, (String)"width", (int)this.width);
        }
        if (this.depth != 1) {
            ColladaImage.appendAttribute((StringBuilder)buf, (String)"depth", (int)this.depth);
        }
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.format = this.getOptionalAttribute("format", attrMap);
        this.height = this.getOptionalIntAttribute("height", attrMap, -1);
        this.width = this.getOptionalIntAttribute("width", attrMap, -1);
        this.depth = this.getOptionalIntAttribute("depth", attrMap, 1);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

