/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Imager;
import hmi.graphics.collada.Optics;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Camera
extends ColladaElement {
    private Asset asset;
    private Optics optics;
    private Imager imager;
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "camera";

    public Camera(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.optics);
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.imager);
        Camera.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Optics.xmlTag())) {
                this.optics = new Optics(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Imager.xmlTag())) {
                this.imager = new Imager(this.getCollada(), tokenizer);
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Camera: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNode(this.optics);
        this.addColladaNode(this.imager);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

