/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.InstanceMaterial;
import hmi.graphics.collada.Param;
import hmi.graphics.collada.TechniqueCommonBindMaterial;
import hmi.graphics.collada.TechniqueCore;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class BindMaterial
extends ColladaElement {
    private ArrayList<Param> params;
    private ArrayList<Extra> extras;
    private TechniqueCommonBindMaterial techniqueCommon;
    private ArrayList<TechniqueCore> techniques;
    private static final String XMLTAG = "bind_material";

    public BindMaterial() {
    }

    public BindMaterial(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public InstanceMaterial getInstanceMaterial(String materialId) {
        return this.techniqueCommon.getInstanceMaterial(materialId);
    }

    public String getMaterialTarget(String symbol) {
        if (this.techniqueCommon == null) {
            return null;
        }
        return this.techniqueCommon.getTarget(symbol);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.techniqueCommon);
        BindMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.params);
        BindMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.techniques);
        BindMaterial.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(TechniqueCommonBindMaterial.xmlTag())) {
                this.techniqueCommon = new TechniqueCommonBindMaterial(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Param.xmlTag())) {
                this.params.add(new Param(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(TechniqueCore.xmlTag())) {
                this.techniques.add(new TechniqueCore(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("BindMaterial: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.techniqueCommon);
        this.addColladaNodes(this.params);
        this.addColladaNodes(this.techniques);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

