/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Contributor;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Asset
extends ColladaElement {
    private List<Contributor> contributors = new ArrayList<Contributor>();
    private String created;
    private List<String> keywordsList = new ArrayList<String>();
    private String modified;
    private String revision;
    private String subject;
    private String title;
    private String unitName;
    private Double unitMeter = 1.0;
    private String upAxis = "Y_UP";
    private static final String XMLTAG = "asset";

    public Asset() {
    }

    public Asset(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public float getUnitMeter() {
        return this.unitMeter.floatValue();
    }

    public String getUpAxis() {
        return this.upAxis;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        Asset.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.contributors);
        Asset.appendTextElement((StringBuilder)buf, (String)"created", (String)this.created, (XMLFormatting)fmt);
        Asset.appendXMLTextElementList((StringBuilder)buf, (XMLFormatting)fmt, (String)"keywords", this.keywordsList);
        Asset.appendTextElement((StringBuilder)buf, (String)"modified", (String)this.modified, (XMLFormatting)fmt);
        Asset.appendTextElement((StringBuilder)buf, (String)"revision", (String)this.revision, (XMLFormatting)fmt);
        Asset.appendTextElement((StringBuilder)buf, (String)"subject", (String)this.subject, (XMLFormatting)fmt);
        Asset.appendTextElement((StringBuilder)buf, (String)"title", (String)this.title, (XMLFormatting)fmt);
        if (this.unitName != null) {
            Asset.appendEmptyTag((StringBuilder)buf, (XMLFormatting)fmt, (String)"unit", (String)"name", (String)this.unitName, (String)"meter", (String)Double.toString(this.unitMeter));
        }
        Asset.appendTextElement((StringBuilder)buf, (String)"up_axis", (String)this.upAxis, (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("contributor")) {
                this.contributors.add(new Contributor(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals("created")) {
                this.created = tokenizer.takeTextElement("created");
                continue;
            }
            if (tag.equals("keywords")) {
                this.keywordsList.add(tokenizer.takeTextElement("keywords"));
                continue;
            }
            if (tag.equals("modified")) {
                this.modified = tokenizer.takeTextElement("modified");
                continue;
            }
            if (tag.equals("revision")) {
                this.revision = tokenizer.takeTextElement("revision");
                continue;
            }
            if (tag.equals("title")) {
                this.title = tokenizer.takeTextElement("title");
                continue;
            }
            if (tag.equals("subject")) {
                this.subject = tokenizer.takeTextElement("subject");
                continue;
            }
            if (tag.equals("unit")) {
                HashMap attr = tokenizer.takeEmptyElement("unit");
                this.unitName = (String)attr.get("name");
                this.unitMeter = Double.parseDouble((String)attr.get("meter"));
                continue;
            }
            if (tag.equals("up_axis")) {
                this.upAxis = tokenizer.takeTextElement("up_axis");
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Asset: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNodes(this.contributors);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

