/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.collada;

import hmi.graphics.collada.Asset;
import hmi.graphics.collada.Channel;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.ColladaElement;
import hmi.graphics.collada.Extra;
import hmi.graphics.collada.Sampler;
import hmi.graphics.collada.Source;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;

public class Animation
extends ColladaElement {
    private Asset asset;
    private ArrayList<Animation> animations = new ArrayList();
    private ArrayList<Source> sources = new ArrayList();
    private ArrayList<Sampler> samplers = new ArrayList();
    private ArrayList<Channel> channels = new ArrayList();
    private ArrayList<Extra> extras = new ArrayList();
    private static final String XMLTAG = "animation";

    public Animation() {
    }

    public Animation(Collada collada, XMLTokenizer tokenizer) throws IOException {
        super(collada);
        this.readXML(tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        this.appendXMLStructure(buf, fmt, (XMLStructure)this.asset);
        Animation.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.animations);
        Animation.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.sources);
        Animation.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.samplers);
        Animation.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.channels);
        Animation.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.extras);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(Asset.xmlTag())) {
                this.asset = new Asset(this.getCollada(), tokenizer);
                continue;
            }
            if (tag.equals(Animation.xmlTag())) {
                this.animations.add(new Animation(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Source.xmlTag())) {
                this.sources.add(new Source(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Sampler.xmlTag())) {
                this.samplers.add(new Sampler(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Channel.xmlTag())) {
                this.channels.add(new Channel(this.getCollada(), tokenizer));
                continue;
            }
            if (tag.equals(Extra.xmlTag())) {
                this.extras.add(new Extra(this.getCollada(), tokenizer));
                continue;
            }
            this.getCollada().warning(tokenizer.getErrorMessage("Animation: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
        this.addColladaNode(this.asset);
        this.addColladaNodes(this.animations);
        this.addColladaNodes(this.sources);
        this.addColladaNodes(this.samplers);
        this.addColladaNodes(this.channels);
        this.addColladaNodes(this.extras);
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

