/*
 * Decompiled with CFR 0.152.
 */
package hmi.facegraphics.deformers;

import hmi.faceanimation.model.MPEG4;
import hmi.facegraphics.deformers.Deformer;
import hmi.facegraphics.deformers.SmoothDeformerClient;
import hmi.facegraphics.deformers.SmoothDeformerServer;
import hmi.math.Bezier2f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class SmoothDeformer
extends Deformer
implements SmoothDeformerServer {
    private float scalex = 1.0f;
    private float scaley = 1.0f;
    private float scalez = 1.0f;
    private int smoothCenter = 0;
    private int smoothSide = 0;
    private boolean useVertexMask;
    private boolean invertVertexMask;
    private Bezier2f bez;
    protected SmoothDeformerClient client;

    @Override
    public void updateSmoothCenter(int smoothCenter) {
        this.smoothCenter = smoothCenter;
        this.bez = null;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setSmoothCenter(int smoothCenter) {
        this.updateSmoothCenter(smoothCenter);
        this.emitSmoothCenter(smoothCenter);
    }

    @Override
    public int getSmoothCenter() {
        return this.smoothCenter;
    }

    @Override
    public void updateSmoothSide(int smoothSide) {
        this.smoothSide = smoothSide;
        this.bez = null;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setSmoothSide(int smoothSide) {
        this.updateSmoothSide(smoothSide);
        this.emitSmoothSide(smoothSide);
    }

    @Override
    public int getSmoothSide() {
        return this.smoothSide;
    }

    @Override
    public void updateScalex(float scale) {
        this.scalex = scale;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setScalex(float scale) {
        this.updateScalex(scale);
        this.emitScalex(scale);
    }

    @Override
    public float getScalex() {
        return this.scalex;
    }

    @Override
    public void updateScaley(float scale) {
        this.scaley = scale;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setScaley(float scale) {
        this.updateScaley(scale);
        this.emitScaley(scale);
    }

    @Override
    public float getScaley() {
        return this.scaley;
    }

    @Override
    public void updateScalez(float scale) {
        this.scalez = scale;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setScalez(float scale) {
        this.updateScalez(scale);
        this.emitScalez(scale);
    }

    @Override
    public float getScalez() {
        return this.scalez;
    }

    @Override
    public void updateUseVM(boolean value) {
        this.useVertexMask = value;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setUseVM(boolean value) {
        this.updateUseVM(value);
        this.emitUseVM(value);
    }

    @Override
    public boolean getUseVM() {
        return this.useVertexMask;
    }

    @Override
    public void updateInvertVM(boolean value) {
        this.invertVertexMask = value;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setInvertVM(boolean value) {
        this.updateInvertVM(value);
        this.emitInvertVM(value);
    }

    @Override
    public boolean getInvertVM() {
        return this.invertVertexMask;
    }

    @Override
    float getWeight(int index) {
        boolean inVM = this.head.getVertexMask(this.fap).contains(index);
        if (this.invertVertexMask) {
            boolean bl = inVM = !inVM;
        }
        if (this.useVertexMask && !inVM) {
            return 0.0f;
        }
        float[] npos = this.head.getNeutralVertexPos(index);
        float dist = this.getDistance(npos, this.fpNeutralPos, this.scalex, this.scaley, this.scalez);
        float x = dist / this.size - (float)this.smoothCenter / 100.0f;
        if (this.bez == null) {
            float[] p0 = new float[]{0.0f - (float)this.smoothCenter / 100.0f, 1.0f};
            float[] v0 = new float[]{0.2f + (float)this.smoothCenter / 100.0f, 0.0f};
            float[] p1 = new float[]{0.5f, 0.5f};
            float[] v1 = new float[]{0.2f, -0.2f};
            float[] p2 = new float[]{1.0f + (float)this.smoothSide / 100.0f, 0.0f};
            float[] v2 = new float[]{0.2f + (float)this.smoothSide / 100.0f, 0.0f};
            float[][] points = new float[][]{p0, p1, p2};
            float[][] vectors = new float[][]{v0, v1, v2};
            float[] weights = new float[]{1.0f, 1.0f, 1.0f};
            this.bez = Bezier2f.bezier2fFromPointsVectorsSingleWeights((float[][])points, (float[][])vectors, (float[])weights);
            for (float i = -1.0f; i < 2.1f; i += 0.1f) {
                float y = this.bez.evalFX(i);
                System.out.println(i + ", " + y);
            }
            System.out.println("-----");
        }
        return this.bez.evalFX(x);
    }

    @Override
    public void copyFrom(Deformer sourceIn) {
        if (sourceIn.getClass() != SmoothDeformer.class) {
            return;
        }
        SmoothDeformer source = (SmoothDeformer)sourceIn;
        this.setSize(source.size);
        this.setSmoothCenter(source.smoothCenter);
        this.setSmoothSide(source.smoothSide);
        this.setScalex(source.scalex);
        this.setScaley(source.scaley);
        this.setScalez(source.scalez);
        this.setUseVM(source.useVertexMask);
        this.setInvertVM(source.invertVertexMask);
    }

    private void emitSmoothCenter(int smoothCenter) {
        if (this.client != null) {
            this.client.updateSmoothCenter(smoothCenter);
        }
    }

    private void emitSmoothSide(int smoothSide) {
        if (this.client != null) {
            this.client.updateSmoothCenter(smoothSide);
        }
    }

    private void emitScalex(float scale) {
        if (this.client != null) {
            this.client.updateScalex(scale);
        }
    }

    private void emitScaley(float scale) {
        if (this.client != null) {
            this.client.updateScaley(scale);
        }
    }

    private void emitScalez(float scale) {
        if (this.client != null) {
            this.client.updateScalez(scale);
        }
    }

    private void emitUseVM(boolean value) {
        if (this.client != null) {
            this.client.updateUseVM(value);
        }
    }

    private void emitInvertVM(boolean value) {
        if (this.client != null) {
            this.client.updateInvertVM(value);
        }
    }

    @Override
    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("fap", Integer.toString(this.fap.getNumber()));
        attrs.put("size", Float.toString(this.size));
        attrs.put("x", Float.toString(this.fpNeutralPos[0]));
        attrs.put("y", Float.toString(this.fpNeutralPos[1]));
        attrs.put("z", Float.toString(this.fpNeutralPos[2]));
        attrs.put("scalex", Float.toString(this.scalex));
        attrs.put("scaley", Float.toString(this.scaley));
        attrs.put("scalez", Float.toString(this.scalez));
        attrs.put("smooth-center", Integer.toString(this.smoothCenter));
        attrs.put("smooth-side", Integer.toString(this.smoothSide));
        attrs.put("use-vertex-mask", Boolean.toString(this.useVertexMask));
        attrs.put("invert-vertex-mask", Boolean.toString(this.invertVertexMask));
        SmoothDeformer.appendEmptyTag((StringBuilder)buf, (XMLFormatting)fmt, (String)"smooth-deformer", attrs);
        return buf;
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        this.fap = MPEG4.getFAP((int)this.getRequiredIntAttribute("fap", attrMap, tokenizer));
        this.size = this.getRequiredFloatAttribute("size", attrMap, tokenizer);
        Float x = Float.valueOf(this.getRequiredFloatAttribute("x", attrMap, tokenizer));
        Float y = Float.valueOf(this.getRequiredFloatAttribute("y", attrMap, tokenizer));
        Float z = Float.valueOf(this.getRequiredFloatAttribute("z", attrMap, tokenizer));
        this.fpNeutralPos = new float[]{x.floatValue(), y.floatValue(), z.floatValue()};
        this.scalex = this.getRequiredFloatAttribute("scalex", attrMap, tokenizer);
        this.scaley = this.getRequiredFloatAttribute("scaley", attrMap, tokenizer);
        this.scalez = this.getRequiredFloatAttribute("scalez", attrMap, tokenizer);
        this.smoothCenter = this.getRequiredIntAttribute("smooth-center", attrMap, tokenizer);
        this.smoothSide = this.getRequiredIntAttribute("smooth-side", attrMap, tokenizer);
        this.useVertexMask = this.getRequiredBooleanAttribute("use-vertex-mask", attrMap, tokenizer);
        this.invertVertexMask = this.getRequiredBooleanAttribute("invert-vertex-mask", attrMap, tokenizer);
        tokenizer.takeSTag("smooth-deformer");
        tokenizer.takeETag("smooth-deformer");
    }
}

