/*
 * Decompiled with CFR 0.152.
 */
package hmi.facegraphics.deformers;

import hmi.faceanimation.model.MPEG4;
import hmi.facegraphics.deformers.Deformer;
import hmi.facegraphics.deformers.EaseDeformerClient;
import hmi.facegraphics.deformers.EaseDeformerServer;
import hmi.facegraphics.deformers.EaseFalloff;
import hmi.facegraphics.deformers.SmoothDeformer;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class EaseDeformer
extends Deformer
implements EaseDeformerServer {
    private float scalex;
    private float scaley;
    private float scalez;
    private int ease;
    private boolean useVertexMask;
    private boolean invertVertexMask;
    protected EaseDeformerClient client;

    public EaseDeformer() {
        this.ease = 0;
        this.scalex = 1.0f;
        this.scaley = 1.0f;
        this.scalez = 1.0f;
    }

    public EaseDeformer(SmoothDeformer smoothDeformer) {
    }

    @Override
    public void updateEase(int ease) {
        this.ease = ease;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setEase(int ease) {
        this.updateEase(ease);
        this.emitEase(ease);
    }

    @Override
    public int getEase() {
        return this.ease;
    }

    @Override
    public void updateScalex(float scale) {
        this.scalex = scale;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setScalex(float scale) {
        this.updateScalex(scale);
        this.emitScalex(scale);
    }

    @Override
    public float getScalex() {
        return this.scalex;
    }

    @Override
    public void updateScaley(float scale) {
        this.scaley = scale;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setScaley(float scale) {
        this.updateScaley(scale);
        this.emitScaley(scale);
    }

    @Override
    public float getScaley() {
        return this.scaley;
    }

    @Override
    public void updateScalez(float scale) {
        this.scalez = scale;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setScalez(float scale) {
        this.updateScalez(scale);
        this.emitScalez(scale);
    }

    @Override
    public float getScalez() {
        return this.scalez;
    }

    @Override
    public void updateUseVM(boolean value) {
        this.useVertexMask = value;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setUseVM(boolean value) {
        this.updateUseVM(value);
        this.emitUseVM(value);
    }

    @Override
    public boolean getUseVM() {
        return this.useVertexMask;
    }

    @Override
    public void updateInvertVM(boolean value) {
        this.invertVertexMask = value;
        this.head.calculateVertexWeights();
        this.deform();
    }

    private void setInvertVM(boolean value) {
        this.updateInvertVM(value);
        this.emitInvertVM(value);
    }

    @Override
    public boolean getInvertVM() {
        return this.invertVertexMask;
    }

    @Override
    float getWeight(int index) {
        boolean inVM = this.head.getVertexMask(this.fap).contains(index);
        if (this.invertVertexMask) {
            boolean bl = inVM = !inVM;
        }
        if (this.useVertexMask && !inVM) {
            return 0.0f;
        }
        float[] npos = this.head.getNeutralVertexPos(index);
        float dist = this.getDistance(npos, this.fpNeutralPos, this.scalex, this.scaley, this.scalez);
        float easeBack = (float)this.ease / 100.0f;
        float alpha = EaseFalloff.getFalloff(easeBack, dist / this.size);
        return alpha;
    }

    @Override
    public void copyFrom(Deformer sourceIn) {
        if (sourceIn.getClass() != EaseDeformer.class) {
            return;
        }
        EaseDeformer source = (EaseDeformer)sourceIn;
        this.setSize(source.size);
        this.setEase(source.ease);
        this.setScalex(source.scalex);
        this.setScaley(source.scaley);
        this.setScalez(source.scalez);
        this.setUseVM(source.useVertexMask);
        this.setInvertVM(source.invertVertexMask);
    }

    private void emitEase(int ease) {
        if (this.client != null) {
            this.client.updateEase(ease);
        }
    }

    private void emitScalex(float scale) {
        if (this.client != null) {
            this.client.updateScalex(scale);
        }
    }

    private void emitScaley(float scale) {
        if (this.client != null) {
            this.client.updateScaley(scale);
        }
    }

    private void emitScalez(float scale) {
        if (this.client != null) {
            this.client.updateScalez(scale);
        }
    }

    private void emitUseVM(boolean value) {
        if (this.client != null) {
            this.client.updateUseVM(value);
        }
    }

    private void emitInvertVM(boolean value) {
        if (this.client != null) {
            this.client.updateInvertVM(value);
        }
    }

    @Override
    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("fap", Integer.toString(this.fap.getNumber()));
        attrs.put("size", Float.toString(this.size));
        attrs.put("x", Float.toString(this.fpNeutralPos[0]));
        attrs.put("y", Float.toString(this.fpNeutralPos[1]));
        attrs.put("z", Float.toString(this.fpNeutralPos[2]));
        attrs.put("scalex", Float.toString(this.scalex));
        attrs.put("scaley", Float.toString(this.scaley));
        attrs.put("scalez", Float.toString(this.scalez));
        attrs.put("ease", Integer.toString(this.ease));
        attrs.put("use-vertex-mask", Boolean.toString(this.useVertexMask));
        attrs.put("invert-vertex-mask", Boolean.toString(this.invertVertexMask));
        EaseDeformer.appendEmptyTag((StringBuilder)buf, (XMLFormatting)fmt, (String)"ease-deformer", attrs);
        return buf;
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        this.fap = MPEG4.getFAP((int)this.getRequiredIntAttribute("fap", attrMap, tokenizer));
        this.size = this.getRequiredFloatAttribute("size", attrMap, tokenizer);
        Float x = Float.valueOf(this.getRequiredFloatAttribute("x", attrMap, tokenizer));
        Float y = Float.valueOf(this.getRequiredFloatAttribute("y", attrMap, tokenizer));
        Float z = Float.valueOf(this.getRequiredFloatAttribute("z", attrMap, tokenizer));
        this.fpNeutralPos = new float[]{x.floatValue(), y.floatValue(), z.floatValue()};
        this.scalex = this.getRequiredFloatAttribute("scalex", attrMap, tokenizer);
        this.scaley = this.getRequiredFloatAttribute("scaley", attrMap, tokenizer);
        this.scalez = this.getRequiredFloatAttribute("scalez", attrMap, tokenizer);
        this.ease = this.getRequiredIntAttribute("ease", attrMap, tokenizer);
        this.useVertexMask = this.getRequiredBooleanAttribute("use-vertex-mask", attrMap, tokenizer);
        this.invertVertexMask = this.getRequiredBooleanAttribute("invert-vertex-mask", attrMap, tokenizer);
        tokenizer.takeSTag("ease-deformer");
        tokenizer.takeETag("ease-deformer");
    }
}

