/*
 * Decompiled with CFR 0.152.
 */
package hmi.facegraphics;

import hmi.faceanimation.FaceController;
import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.MPEG4;
import hmi.faceanimation.model.MPEG4Configuration;
import hmi.facegraphics.GLHead;
import hmi.graphics.opengl.scenegraph.GLScene;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class HMIFaceController
implements FaceController {
    private GLScene theGLScene;
    private ArrayList<String> possibleFaceMorphTargetNames = new ArrayList();
    private MPEG4Configuration currentConfig = new MPEG4Configuration();
    private GLHead glHead;
    private HashMap<String, Float> oldDesiredMorphTargets = new HashMap();
    private HashMap<String, Float> desiredMorphTargets = new HashMap();

    public HMIFaceController(GLScene gls, GLHead h) {
        this.theGLScene = gls;
        this.glHead = h;
    }

    public synchronized void setMPEG4Configuration(MPEG4Configuration config) {
        this.currentConfig = config;
    }

    public synchronized void addMPEG4Configuration(MPEG4Configuration config) {
        this.currentConfig.addValues(config);
    }

    public synchronized void removeMPEG4Configuration(MPEG4Configuration config) {
        this.currentConfig.removeValues(config);
    }

    public ArrayList<String> getPossibleFaceMorphTargetNames() {
        return this.possibleFaceMorphTargetNames;
    }

    public void setPossibleFaceMorphTargetNames(ArrayList<String> names) {
        this.possibleFaceMorphTargetNames = names;
    }

    public synchronized void copy() {
        String targetName;
        for (FAP fap : MPEG4.getFAPs().values()) {
            Integer value = this.currentConfig.getValue(fap.getIndex());
            if (value == null) continue;
            this.glHead.getDeformer(fap).setValue(value);
        }
        this.glHead.deformWhenScheduled();
        String[] targetNames = new String[this.oldDesiredMorphTargets.size()];
        float[] targetWeights = new float[this.oldDesiredMorphTargets.size()];
        int i = 0;
        Iterator<String> i$ = this.oldDesiredMorphTargets.keySet().iterator();
        while (i$.hasNext()) {
            targetNames[i] = targetName = i$.next();
            targetWeights[i] = this.oldDesiredMorphTargets.get(targetName).floatValue();
            ++i;
        }
        this.theGLScene.removeMorphTargets(targetNames, targetWeights);
        targetNames = new String[this.desiredMorphTargets.size()];
        targetWeights = new float[this.desiredMorphTargets.size()];
        i = 0;
        i$ = this.desiredMorphTargets.keySet().iterator();
        while (i$.hasNext()) {
            targetNames[i] = targetName = i$.next();
            targetWeights[i] = this.desiredMorphTargets.get(targetName).floatValue();
            ++i;
        }
        this.theGLScene.addMorphTargets(targetNames, targetWeights);
        this.oldDesiredMorphTargets = new HashMap<String, Float>(this.desiredMorphTargets);
    }

    public synchronized void addMorphTargets(String[] targetNames, float[] weights) {
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = weights[i];
            Float fl = this.desiredMorphTargets.get(targetNames[i]);
            if (fl != null) {
                w += fl.floatValue();
            }
            if (w == 0.0f) {
                this.desiredMorphTargets.remove(targetNames[i]);
                continue;
            }
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    public synchronized void removeMorphTargets(String[] targetNames, float[] weights) {
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = -weights[i];
            Float fl = this.desiredMorphTargets.get(targetNames[i]);
            if (fl != null) {
                w += fl.floatValue();
            }
            if (w == 0.0f) {
                this.desiredMorphTargets.remove(targetNames[i]);
                continue;
            }
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }
}

