/*
 * Decompiled with CFR 0.152.
 */
package hmi.facegraphics;

import hmi.faceanimation.model.Eye;
import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.FeaturePoint;
import hmi.faceanimation.model.Head;
import hmi.faceanimation.model.LowerJaw;
import hmi.faceanimation.model.MPEG4;
import hmi.faceanimation.model.Neck;
import hmi.facegraphics.deformers.Deformer;
import hmi.facegraphics.deformers.EaseDeformer;
import hmi.facegraphics.deformers.SmoothDeformer;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class GLHead
extends XMLStructureAdapter
implements Head {
    private static final long serialVersionUID = -1151644062991823029L;
    private HashMap<FeaturePoint, float[]> fpPositions;
    private ArrayList<FAP> keepSync;
    private HashMap<FAP, Deformer> deformers;
    private HashMap<FAP, ArrayList<Integer>> vertexMasks;
    private HashMap<String, Float> fapus;
    private boolean fapusDirty = true;
    private float xcenter;
    private float xsize;
    private Eye leftEye;
    private Eye rightEye;
    private LowerJaw lowerJaw;
    private Neck neck;
    private HashMap<FAP, HashMap<Integer, float[]>> displacements;
    private boolean displacementsDirty = false;
    private boolean deformScheduled = false;
    private float[] vertexData;
    private float[] neutralVertexData;
    private GLSkinnedMesh faceMesh;
    private final Operation mergeOp = Operation.SUM;
    private static final String XMLTAG = "faceeditor-parameters";

    public GLHead() {
        this.fpPositions = new HashMap();
        this.keepSync = new ArrayList();
        this.deformers = new HashMap();
        this.vertexMasks = new HashMap();
        this.fapus = new HashMap();
        this.displacements = new HashMap();
    }

    public float[] getFPPosition(FeaturePoint fp) {
        if (!this.fpPositions.containsKey(fp)) {
            return null;
        }
        return this.fpPositions.get(fp);
    }

    private float[] getFPPosition(String fpString) {
        return this.getFPPosition(MPEG4.getFeaturePoint((String)fpString));
    }

    public void setFPPosition(FeaturePoint fp, float[] pos) {
        this.fpPositions.put(fp, pos);
        this.fapusDirty = true;
    }

    public void setKeepSync(FAP fap, boolean sync) {
        if (sync && !this.keepSync.contains(fap)) {
            this.keepSync.add(fap);
        } else if (!sync && this.keepSync.contains(fap)) {
            this.keepSync.remove(fap);
        }
    }

    public boolean getKeepSync(FAP fap) {
        return this.keepSync.contains(fap);
    }

    public void setDeformer(FAP fap, Deformer deformer) {
        this.deformers.put(fap, deformer);
    }

    public Deformer getDeformer(FAP fap) {
        if (!this.deformers.containsKey(fap)) {
            EaseDeformer deformer = new EaseDeformer();
            deformer.setHead(this);
            deformer.setFAP(fap);
            this.deformers.put(fap, deformer);
            return deformer;
        }
        Deformer deformer = this.deformers.get(fap);
        return deformer;
    }

    public ArrayList<Integer> getVertexMask(FAP fap) {
        if (!this.vertexMasks.containsKey(fap)) {
            ArrayList<Integer> vertexMask = new ArrayList<Integer>();
            this.vertexMasks.put(fap, vertexMask);
            return vertexMask;
        }
        return this.vertexMasks.get(fap);
    }

    public float getFAPU(String fapu) {
        this.calculateFAPUs();
        if (this.fapus.containsKey(fapu)) {
            return this.fapus.get(fapu).floatValue();
        }
        return 0.0f;
    }

    private void calculateFAPUs() {
        int STEPS = 1024;
        if (!this.fapusDirty) {
            return;
        }
        this.fapusDirty = false;
        this.fapus.put("AU", Float.valueOf(1.0E-4f));
        float[] eyeLeft = this.getFPPosition("3.5");
        float[] eyeRight = this.getFPPosition("3.6");
        float[] es0Center = null;
        if (eyeLeft != null && eyeRight != null) {
            this.fapus.put("ES", Float.valueOf(this.calculateDistance(eyeLeft, eyeRight) / 1024.0f));
            es0Center = this.calculateCenter(eyeLeft, eyeRight);
        }
        float[] upperLid = this.getFPPosition("3.1");
        float[] lowerLid = this.getFPPosition("3.3");
        if (upperLid != null && lowerLid != null) {
            this.fapus.put("IRISD", Float.valueOf(this.calculateDistance(upperLid, lowerLid) / 1024.0f));
        }
        float[] noseBottom = this.getFPPosition("9.15");
        if (es0Center != null && noseBottom != null) {
            this.fapus.put("ENS", Float.valueOf(this.calculateDistance(es0Center, noseBottom) / 1024.0f));
        }
        float[] mouthTop = this.getFPPosition("8.1");
        if (noseBottom != null && mouthTop != null) {
            this.fapus.put("MNS", Float.valueOf(this.calculateDistance(noseBottom, mouthTop) / 1024.0f));
        }
        float[] mouthLeft = this.getFPPosition("8.3");
        float[] mouthRight = this.getFPPosition("8.4");
        if (mouthLeft != null && mouthRight != null) {
            this.fapus.put("MW", Float.valueOf(this.calculateDistance(mouthLeft, mouthRight) / 1024.0f));
        }
    }

    private float calculateDistance(float[] first, float[] second) {
        float dx = first[0] - second[0];
        float dy = first[1] - second[1];
        float dz = first[2] - second[2];
        float dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        return dist;
    }

    private float[] calculateCenter(float[] first, float[] second) {
        float dx = first[0] - second[0];
        float dy = first[1] - second[1];
        float dz = first[2] - second[2];
        float[] center = new float[]{first[0] + dx / 2.0f, first[1] + dy / 2.0f, first[2] + dz / 2.0f};
        return center;
    }

    public int getNumVertices() {
        return this.vertexData.length / 3;
    }

    public float[] getVertexData() {
        this.vertexData = this.faceMesh.getVertexData(0, this.vertexData);
        return this.vertexData;
    }

    private void calculateHeadWidth() {
        int numVertices = this.vertexData.length / 3;
        float xmin = 0.0f;
        float xmax = 0.0f;
        for (int i = 0; i < numVertices; ++i) {
            float x = this.vertexData[i * 3];
            xmin = Math.min(xmin, x);
            xmax = Math.max(xmax, x);
        }
        this.xsize = xmax - xmin;
        this.xcenter = xmin + this.xsize / 2.0f;
    }

    public float getWidth() {
        return this.xsize;
    }

    public float getXCenter() {
        return this.xcenter;
    }

    private void setNeutralVertexData(float[] neutralVertexData) {
        this.neutralVertexData = neutralVertexData;
    }

    public float[] getNeutralVertexPos(int index) {
        int vindex = index * 3;
        float[] retval = new float[]{this.neutralVertexData[vindex], this.neutralVertexData[vindex + 1], this.neutralVertexData[vindex + 2]};
        return retval;
    }

    public void setFaceMesh(GLSkinnedMesh faceMesh) {
        this.faceMesh = faceMesh;
        this.getVertexData();
        this.setNeutralVertexData((float[])this.vertexData.clone());
        this.calculateHeadWidth();
        this.calculateVertexWeights();
    }

    public void calculateVertexWeights() {
        this.faceMesh.setUseFaps(true);
        HashMap faps = MPEG4.getFAPs();
        int nrOfFaps = faps.size();
        float[][] directionVectors = new float[nrOfFaps][3];
        for (FAP fap : faps.values()) {
            directionVectors[fap.index] = this.getDeformer(fap).getFullDisplacement();
        }
        this.faceMesh.setFapDirectionVectors(directionVectors);
        int numVertices = this.getNumVertices();
        int[] fapCount = new int[numVertices];
        TreeMap fapIndices = new TreeMap();
        TreeMap fapWeights = new TreeMap();
        int numInfluences = 0;
        HashMap<FAP, HashMap<Integer, Float>> fapDeformerWeights = new HashMap<FAP, HashMap<Integer, Float>>();
        for (FAP fap : faps.values()) {
            HashMap<Integer, Float> deformerWeights = this.getDeformer(fap).getVertexWeights();
            fapDeformerWeights.put(fap, deformerWeights);
            Iterator<Object> i$ = deformerWeights.keySet().iterator();
            while (i$.hasNext()) {
                int vertexIndex;
                int n = vertexIndex = ((Integer)i$.next()).intValue();
                fapCount[n] = fapCount[n] + 1;
                if (fapIndices.get(vertexIndex) == null) {
                    fapIndices.put(vertexIndex, new ArrayList());
                }
                ((ArrayList)fapIndices.get(vertexIndex)).add(fap.index);
                float weight = deformerWeights.get(vertexIndex).floatValue();
                if (fapWeights.get(vertexIndex) == null) {
                    fapWeights.put(vertexIndex, new ArrayList());
                }
                ((ArrayList)fapWeights.get(vertexIndex)).add(Float.valueOf(weight));
                ++numInfluences;
            }
        }
        int[] fapIndex = new int[numInfluences];
        float[] fapWeight = new float[numInfluences];
        int currentInfluence = 0;
        for (ArrayList indices : fapIndices.values()) {
            Iterator i$ = indices.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                fapIndex[currentInfluence++] = index;
            }
        }
        currentInfluence = 0;
        for (ArrayList weights : fapWeights.values()) {
            Iterator i$ = weights.iterator();
            while (i$.hasNext()) {
                float weight = ((Float)i$.next()).floatValue();
                fapWeight[currentInfluence++] = weight;
            }
        }
        this.faceMesh.setFapVertexWeights(fapCount, fapIndex, fapWeight);
        this.scheduleDeform();
    }

    public void scheduleDeform() {
        this.deformScheduled = true;
    }

    public void deformWhenScheduled() {
        if (!this.deformScheduled) {
            return;
        }
        HashMap faps = MPEG4.getFAPs();
        int nrOfFaps = faps.size();
        float[] amplitudes = new float[nrOfFaps];
        for (FAP fap2 : faps.values()) {
            amplitudes[fap2.index] = (float)this.getDeformer(fap2).getValue() / 1024.0f;
        }
        this.faceMesh.setFapAmplitudes(amplitudes);
        this.faceMesh.deform();
        if (this.leftEye != null) {
            this.leftEye.copy();
        }
        if (this.rightEye != null) {
            this.rightEye.copy();
        }
        if (this.neck != null) {
            this.neck.copy();
        }
        if (this.lowerJaw != null) {
            this.lowerJaw.copy();
        }
    }

    @Deprecated
    public void setDisplacements(FAP fap, HashMap<Integer, float[]> disp) {
        HashMap faps = MPEG4.getFAPs();
        int nrOfFaps = faps.size();
        float[] amplitudes = new float[nrOfFaps];
        for (FAP fap2 : faps.values()) {
            amplitudes[fap2.index] = (float)this.getDeformer(fap2).getValue() / 1024.0f;
        }
        this.faceMesh.setFapAmplitudes(amplitudes);
        this.faceMesh.deform();
    }

    public void clearDisplacements() {
        for (FAP fap : MPEG4.getFAPs().values()) {
            this.getDeformer(fap).setValue(0);
        }
    }

    @Deprecated
    public void applyDisplacements() {
        if (!this.displacementsDirty) {
            return;
        }
        this.displacementsDirty = false;
        HashMap flat = new HashMap();
        for (HashMap<Integer, float[]> disp : this.displacements.values()) {
            for (Map.Entry<Integer, float[]> entry : disp.entrySet()) {
                Integer index = entry.getKey();
                if (!flat.containsKey(index)) {
                    flat.put(index, new ArrayList());
                }
                ((ArrayList)flat.get(index)).add(disp.get(index));
            }
        }
        HashMap<Integer, float[]> merged = new HashMap<Integer, float[]>();
        Iterator i$ = flat.keySet().iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            ArrayList vdisps = (ArrayList)flat.get(index);
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            for (float[] vdisp : vdisps) {
                x += vdisp[0];
                y += vdisp[1];
                z += vdisp[2];
            }
            if (this.mergeOp.equals((Object)Operation.AVERAGE)) {
                int num = vdisps.size();
                x /= (float)num;
                y /= (float)num;
                x /= (float)num;
            }
            merged.put(index, new float[]{x, y, z});
        }
        for (int vindex = 0; vindex < this.vertexData.length; vindex += 3) {
            int index = vindex / 3;
            float[] npos = new float[3];
            if (merged.containsKey(index)) {
                npos[0] = this.neutralVertexData[vindex] + ((float[])merged.get(index))[0];
                npos[1] = this.neutralVertexData[vindex + 1] + ((float[])merged.get(index))[1];
                npos[2] = this.neutralVertexData[vindex + 2] + ((float[])merged.get(index))[2];
            } else {
                npos[0] = this.neutralVertexData[vindex];
                npos[1] = this.neutralVertexData[vindex + 1];
                npos[2] = this.neutralVertexData[vindex + 2];
            }
            this.vertexData[vindex] = npos[0];
            this.vertexData[vindex + 1] = npos[1];
            this.vertexData[vindex + 2] = npos[2];
        }
        this.faceMesh.setVertexData(0, this.vertexData);
    }

    public void setEyes(Eye leftEye, Eye rightEye) {
        this.leftEye = leftEye;
        this.rightEye = rightEye;
    }

    public Eye getLeftEye() {
        return this.leftEye;
    }

    public Eye getRightEye() {
        return this.rightEye;
    }

    public void setLowerJaw(LowerJaw lowerJaw) {
        this.lowerJaw = lowerJaw;
    }

    public LowerJaw getLowerJaw() {
        return this.lowerJaw;
    }

    public void setNeck(Neck neck) {
        this.neck = neck;
    }

    public Neck getNeck() {
        return this.neck;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        GLHead.appendSTag((StringBuilder)buf, (String)"fp-positions", (XMLFormatting)fmt);
        for (FeaturePoint fp : this.fpPositions.keySet()) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("fp", fp.toString());
            float[] pos = this.fpPositions.get(fp);
            attrs.put("x", Float.toString(pos[0]));
            attrs.put("y", Float.toString(pos[1]));
            attrs.put("z", Float.toString(pos[2]));
            GLHead.appendEmptyTag((StringBuilder)buf, (XMLFormatting)fmt, (String)"fp-position", attrs);
        }
        GLHead.appendETag((StringBuilder)buf, (String)"fp-positions", (XMLFormatting)fmt);
        GLHead.appendSTag((StringBuilder)buf, (String)"keep-syncs", (XMLFormatting)fmt);
        int[] ints = new int[this.keepSync.size()];
        int index = 0;
        for (FAP fap : this.keepSync) {
            if (fap == null) continue;
            ints[index++] = fap.getNumber();
        }
        GLHead.appendInts((StringBuilder)buf, (int[])ints, (char)' ', (XMLFormatting)fmt, (int)20);
        GLHead.appendETag((StringBuilder)buf, (String)"keep-syncs", (XMLFormatting)fmt);
        GLHead.appendSTag((StringBuilder)buf, (String)"deformers", (XMLFormatting)fmt);
        for (FAP fap : this.deformers.keySet()) {
            if (fap == null) continue;
            Deformer deformer = this.deformers.get(fap);
            deformer.appendContent(buf, fmt);
        }
        GLHead.appendETag((StringBuilder)buf, (String)"deformers", (XMLFormatting)fmt);
        GLHead.appendSTag((StringBuilder)buf, (String)"vertex-masks", (XMLFormatting)fmt);
        for (FAP fap : this.vertexMasks.keySet()) {
            ArrayList<Integer> list;
            if (fap == null || (list = this.vertexMasks.get(fap)).size() == 0) continue;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("fap", Integer.toString(fap.getNumber()));
            GLHead.appendSTag((StringBuilder)buf, (String)"vertex-mask", attrs);
            ints = new int[list.size()];
            index = 0;
            for (int vindex : list) {
                ints[index++] = vindex;
            }
            GLHead.appendInts((StringBuilder)buf, (int[])ints, (char)' ', (XMLFormatting)fmt, (int)20);
            GLHead.appendETag((StringBuilder)buf, (String)"vertex-mask", (XMLFormatting)fmt);
        }
        GLHead.appendETag((StringBuilder)buf, (String)"vertex-masks", (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        tokenizer.takeSTag("fp-positions");
        while (tokenizer.getTagName().equals("fp-position")) {
            HashMap attrMap = tokenizer.getAttributes();
            String fp = this.getRequiredAttribute("fp", attrMap, tokenizer);
            Float x = Float.valueOf(this.getRequiredFloatAttribute("x", attrMap, tokenizer));
            Float y = Float.valueOf(this.getRequiredFloatAttribute("y", attrMap, tokenizer));
            Float z = Float.valueOf(this.getRequiredFloatAttribute("z", attrMap, tokenizer));
            this.fpPositions.put(MPEG4.getFeaturePoint((String)fp), new float[]{x.floatValue(), y.floatValue(), z.floatValue()});
            tokenizer.takeSTag("fp-position");
            tokenizer.takeETag("fp-position");
        }
        tokenizer.takeETag("fp-positions");
        tokenizer.takeSTag("keep-syncs");
        int[] ints = GLHead.decodeIntArray((String)tokenizer.getTrimmedCharData(), (String)" \n");
        for (int index = 0; index < ints.length; ++index) {
            this.keepSync.add(MPEG4.getFAP((int)ints[index]));
        }
        tokenizer.takeCharData();
        tokenizer.takeETag("keep-syncs");
        tokenizer.takeSTag("deformers");
        while (true) {
            Deformer deformer = null;
            if (tokenizer.getTagName().equals("ease-deformer")) {
                deformer = new EaseDeformer();
            } else {
                if (!tokenizer.getTagName().equals("smooth-deformer")) break;
                deformer = new SmoothDeformer();
            }
            deformer.decodeContent(tokenizer);
            deformer.setHead(this);
            this.deformers.put(deformer.getFAP(), deformer);
        }
        tokenizer.takeETag("deformers");
        tokenizer.takeSTag("vertex-masks");
        while (tokenizer.getTagName().equals("vertex-mask")) {
            HashMap attrMap = tokenizer.getAttributes();
            tokenizer.takeSTag("vertex-mask");
            FAP fap = MPEG4.getFAP((int)this.getRequiredIntAttribute("fap", attrMap, tokenizer));
            this.vertexMasks.put(fap, new ArrayList());
            ints = GLHead.decodeIntArray((String)tokenizer.getTrimmedCharData(), (String)" \n");
            for (int index = 0; index < ints.length; ++index) {
                this.vertexMasks.get(fap).add(ints[index]);
            }
            tokenizer.takeCharData();
            tokenizer.takeETag("vertex-mask");
        }
        tokenizer.takeETag("vertex-masks");
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    private static enum Operation {
        SUM,
        AVERAGE;

    }
}

