/*
 * Decompiled with CFR 0.152.
 */
package hmi.facegraphics.deformers;

import java.text.DecimalFormat;

public class EaseFalloff {
    private static Method method = Method.SIMPLE;
    private static float smoothLeft = 0.2f;
    private static float smoothRight = 0.2f;

    public static void setMethod(Method method) {
        EaseFalloff.method = method;
    }

    public static void setSmoothLeft(float smoothLeft) {
        EaseFalloff.smoothLeft = smoothLeft;
    }

    public static void setSmoothRight(float smoothRight) {
        EaseFalloff.smoothRight = smoothRight;
    }

    static float getFalloff(float ease, float distanceRatio) {
        if (method == Method.SIMPLE) {
            return EaseFalloff.getSimpleFalloff(ease, distanceRatio);
        }
        if (method == Method.SMOOTH) {
            return EaseFalloff.getSmoothFalloff(ease, distanceRatio);
        }
        return 0.0f;
    }

    static float getSimpleFalloff(float ease, float distanceRatio) {
        float retval = 1.0f - EaseFalloff.principalValue(EaseFalloff.mapEaseToExponent(ease), distanceRatio);
        return retval;
    }

    static float getSmoothFalloff(float ease, float distanceRatio) {
        float pv = EaseFalloff.principalValue(EaseFalloff.mapEaseToExponent(ease), distanceRatio);
        float retval = 1.0f - EaseFalloff.smooth(distanceRatio, pv);
        return retval;
    }

    private static float smoothLeft(float x, float y) {
        return (float)((Math.tanh((double)x / (0.5 * (double)smoothLeft) * Math.PI - Math.PI) / 2.0 + 0.5) * (double)y);
    }

    private static float smoothRight(float x, float y) {
        return (float)((Math.tanh(((double)x - (1.0 - (double)smoothRight)) / (0.5 * (double)smoothRight) * Math.PI - Math.PI) / 2.0 + 0.5) * (double)(1.0f - y) + (double)y);
    }

    private static float smooth(float x, float y) {
        return EaseFalloff.smoothLeft(x, EaseFalloff.smoothRight(x, y));
    }

    static float mapEaseToExponent(float ease) {
        if (ease <= 0.0f) {
            return ease + 1.0f;
        }
        if (ease > 0.0f) {
            return ease * 5.0f + 1.0f;
        }
        return 0.0f;
    }

    static float principalValue(float exponent, float distanceRatio) {
        return (float)Math.pow(distanceRatio, exponent);
    }

    public static void main(String[] args) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        for (float x = 0.0f; x < 1.05f; x += 0.05f) {
            float pv = EaseFalloff.principalValue(1.0f, x);
            System.out.println("x: " + formatter.format(x) + ", normal: " + formatter.format(pv) + ", smooth left: " + formatter.format(EaseFalloff.smoothLeft(x, pv)) + ", smooth right: " + formatter.format(EaseFalloff.smoothRight(x, pv)) + ", smooth both: " + formatter.format(EaseFalloff.smooth(x, pv)));
        }
    }

    public static enum Method {
        SIMPLE,
        SMOOTH;

    }
}

