/*
 * Decompiled with CFR 0.152.
 */
package hmi.facegraphics.deformers;

import hmi.faceanimation.model.FAP;
import hmi.faceanimation.model.MPEG4;
import hmi.facegraphics.GLHead;
import hmi.facegraphics.deformers.DeformerClient;
import hmi.facegraphics.deformers.DeformerServer;
import hmi.math.Vec3f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public abstract class Deformer
extends XMLStructureAdapter
implements DeformerServer {
    protected float size;
    protected FAP fap;
    protected int value;
    protected GLHead head;
    protected float[] fpNeutralPos;
    protected float[] fpPos;
    private float[] displacement;
    protected DeformerClient client;

    public void setHead(GLHead head) {
        this.head = head;
    }

    public void setFAP(FAP fap) {
        this.fap = fap;
        this.fpNeutralPos = this.head.getFPPosition(fap.getFeaturePoint());
        if (this.fpNeutralPos == null) {
            this.fpNeutralPos = new float[]{0.0f, 0.0f, 0.0f};
        }
    }

    public FAP getFAP() {
        return this.fap;
    }

    @Override
    public void updateSize(float size) {
        this.size = size;
        this.head.calculateVertexWeights();
        this.deform();
    }

    public void setSize(float size) {
        this.updateSize(size);
        this.emitSize(size);
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public void updateValue(int value) {
        this.value = value;
        this.deform();
        if (this.client != null) {
            this.client.setDisplacement(this.fpPos);
        }
    }

    public void setValue(int value) {
        this.updateValue(value);
        this.emitValue(value);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public void setClient(DeformerClient client) {
        this.client = client;
    }

    protected void emitSize(float size) {
        if (this.client != null) {
            this.client.updateSize(size);
        }
    }

    protected void emitValue(int value) {
        if (this.client != null) {
            this.client.updateValue(value);
        }
    }

    public abstract void copyFrom(Deformer var1);

    public void deform() {
        if (this.fap.getNumber() == 23) {
            this.head.getLeftEye().setYawValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 24) {
            this.head.getRightEye().setYawValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 25) {
            this.head.getLeftEye().setPitchValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 26) {
            this.head.getRightEye().setPitchValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 27) {
            this.head.getLeftEye().setThrustValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 28) {
            this.head.getRightEye().setThrustValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 48) {
            this.head.getNeck().setPitchValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 49) {
            this.head.getNeck().setYawValue((float)this.value);
            return;
        }
        if (this.fap.getNumber() == 50) {
            this.head.getNeck().setRollValue((float)this.value);
            return;
        }
        float[] disp = this.getDisplacement();
        float[] opos = this.fpNeutralPos;
        float[] fpPos = new float[]{opos[0] + disp[0], opos[1] + disp[1], opos[2] + disp[2]};
        this.fpPos = fpPos;
        if (this.fap.getNumber() == 3) {
            this.head.getLowerJaw().setOpen(disp);
        }
        if (this.fap.getNumber() == 14) {
            this.head.getLowerJaw().setThrust(disp);
        }
        if (this.fap.getNumber() == 15) {
            this.head.getLowerJaw().setShift(disp);
        }
        this.head.scheduleDeform();
    }

    public float[] getDisplacement() {
        this.calculateDisplacement();
        return this.displacement;
    }

    public float[] getFullDisplacement() {
        int temp = this.value;
        this.value = 1024;
        this.calculateDisplacement();
        this.value = temp;
        float[] fullDisplacement = (float[])this.displacement.clone();
        this.calculateDisplacement();
        return fullDisplacement;
    }

    private void calculateDisplacement() {
        if (this.fap == null) {
            return;
        }
        String fapu = this.fap.getUnit().toString();
        float unit = this.head.getFAPU(fapu);
        if (unit == 0.0f && !fapu.equals("NA")) {
            System.err.println("FAPU " + fapu + " not available, continuing with dummy value");
            unit = 0.01f;
        }
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        switch (this.fap.getDirection()) {
            case UP: {
                dy = unit * (float)this.value;
                break;
            }
            case DOWN: {
                dy = -unit * (float)this.value;
                break;
            }
            case LEFT: {
                dx = unit * (float)this.value;
                break;
            }
            case RIGHT: {
                dx = -unit * (float)this.value;
                break;
            }
            case FORWARD: {
                dz = unit * (float)this.value;
            }
        }
        this.displacement = new float[]{dx, dy, dz};
    }

    float getDistance(float[] a, float[] b, float scalex, float scaley, float scalez) {
        float[] dst = new float[3];
        Vec3f.sub((float[])dst, (float[])a, (float[])b);
        dst[0] = dst[0] / scalex;
        dst[1] = dst[1] / scaley;
        dst[2] = dst[2] / scalez;
        return Vec3f.length((float[])dst);
    }

    float getWeight(int index) {
        return 0.0f;
    }

    public HashMap<Integer, Float> getVertexWeights() {
        HashMap<Integer, Float> weights = new HashMap<Integer, Float>();
        int numVertices = this.head.getNumVertices();
        for (int index = 0; index < numVertices; ++index) {
            float alpha = this.getWeight(index);
            if (!(alpha > 0.0f)) continue;
            weights.put(index, Float.valueOf(alpha));
        }
        return weights;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        HashMap<String, Number> attrs = new HashMap<String, Number>();
        attrs.put("fap", this.fap.getNumber());
        attrs.put("size", Float.valueOf(this.size));
        attrs.put("x", Float.valueOf(this.fpNeutralPos[0]));
        attrs.put("y", Float.valueOf(this.fpNeutralPos[1]));
        attrs.put("z", Float.valueOf(this.fpNeutralPos[2]));
        Deformer.appendEmptyTag((StringBuilder)buf, (XMLFormatting)fmt, (String)"deformer", attrs);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = tokenizer.getAttributes();
        this.fap = MPEG4.getFAP((int)this.getRequiredIntAttribute("fap", attrMap, tokenizer));
        this.size = this.getRequiredFloatAttribute("size", attrMap, tokenizer);
        Float x = Float.valueOf(this.getRequiredFloatAttribute("x", attrMap, tokenizer));
        Float y = Float.valueOf(this.getRequiredFloatAttribute("y", attrMap, tokenizer));
        Float z = Float.valueOf(this.getRequiredFloatAttribute("z", attrMap, tokenizer));
        this.fpNeutralPos = new float[]{x.floatValue(), y.floatValue(), z.floatValue()};
        tokenizer.takeSTag("deformer");
        tokenizer.takeETag("deformer");
    }
}

