/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.loader;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.EngineLoader;
import asap.environment.Loader;
import asap.environment.impl.JComponentEmbodiment;
import asap.utils.Environment;
import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.SingleThreadedPlanPlayer;
import hmi.faceanimation.FaceController;
import hmi.faceanimation.FaceEmbodiment;
import hmi.faceanimation.converters.EmotionConverter;
import hmi.faceanimation.converters.FACSConverter;
import hmi.faceanimation.converters.ui.EmotionConverterFrame;
import hmi.faceanimation.converters.ui.FACSConverterFrame;
import hmi.faceanimation.converters.ui.MPEG4ControllerFrame;
import hmi.faceengine.FacePlanner;
import hmi.faceengine.facebinding.FaceBinding;
import hmi.faceengine.faceunit.TimedFaceUnit;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FaceEngineLoader
implements EngineLoader {
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private FaceEmbodiment m4e = null;
    private JComponentEmbodiment jce = null;
    private boolean initUI = false;
    private Engine engine = null;
    private Player facePlayer = null;
    private EmotionConverter econv;
    private FACSConverter fconv;
    private PlanManager<TimedFaceUnit> planManager = null;
    private String id = "";
    private FaceBinding facebinding = null;
    private AsapVirtualHuman theVirtualHuman = null;

    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theVirtualHuman = avh;
        for (Loader e : requiredLoaders) {
            if (e instanceof EmbodimentLoader && ((EmbodimentLoader)e).getEmbodiment() instanceof FaceEmbodiment) {
                this.m4e = (FaceEmbodiment)((EmbodimentLoader)e).getEmbodiment();
            }
            if (!(e instanceof EmbodimentLoader) || !(((EmbodimentLoader)e).getEmbodiment() instanceof JComponentEmbodiment)) continue;
            this.jce = (JComponentEmbodiment)((EmbodimentLoader)e).getEmbodiment();
        }
        if (this.m4e == null) {
            throw new RuntimeException("FaceEngineLoader requires an EmbodimentLoader containing a FaceEmbodiment");
        }
        while (!tokenizer.atETag("Loader")) {
            this.readSection(tokenizer);
        }
        this.constructEngine(tokenizer);
    }

    public void unload() {
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("FaceBinding")) {
            attrMap = tokenizer.getAttributes();
            this.facebinding = new FaceBinding();
            try {
                this.facebinding.readXML(new Resources(this.adapter.getOptionalAttribute("resources", attrMap, "")).getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer)));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannnot load FaceBinding: " + e);
            }
            tokenizer.takeEmptyElement("FaceBinding");
        } else if (tokenizer.atSTag("FaceUI")) {
            if (this.jce == null) {
                throw tokenizer.getXMLScanException("Cannot add FaceUI when no JComponentEmbodiment is set");
            }
            this.initUI = true;
            tokenizer.takeSTag("FaceUI");
            tokenizer.takeETag("FaceUI");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    private void constructEngine(XMLTokenizer tokenizer) {
        if (this.facebinding == null) {
            throw tokenizer.getXMLScanException("facebinding is null, cannot build faceplanner ");
        }
        this.planManager = new PlanManager();
        this.facePlayer = new DefaultPlayer((PlanPlayer)new SingleThreadedPlanPlayer(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), this.planManager));
        this.econv = new EmotionConverter();
        this.fconv = new FACSConverter();
        FaceController fc = null;
        if (this.m4e != null) {
            fc = this.m4e.getFaceController();
        }
        FacePlanner facePlanner = new FacePlanner(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), fc, this.fconv, this.econv, this.facebinding, this.planManager);
        this.engine = new DefaultEngine((Planner)facePlanner, this.facePlayer, this.planManager);
        this.engine.setId(this.id);
        this.theVirtualHuman.getElckerlycRealizer().addEngine(this.engine);
        if (this.initUI) {
            final JPanel faceUIPanel = new JPanel();
            JButton showFACSConverter = new JButton();
            showFACSConverter.setText("FACS Converter");
            showFACSConverter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new FACSConverterFrame(FaceEngineLoader.this.fconv, FaceEngineLoader.this.m4e.getFaceController());
                }
            });
            faceUIPanel.add(showFACSConverter);
            JButton showEmotionConverter = new JButton();
            showEmotionConverter.setText("Emotion Converter");
            showEmotionConverter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new EmotionConverterFrame(FaceEngineLoader.this.econv, FaceEngineLoader.this.m4e.getFaceController());
                }
            });
            faceUIPanel.add(showEmotionConverter);
            JButton showDirectMPEG4Control = new JButton();
            showDirectMPEG4Control.setText("Direct MPEG4 Control");
            showDirectMPEG4Control.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new MPEG4ControllerFrame(FaceEngineLoader.this.m4e.getFaceController());
                }
            });
            faceUIPanel.add(showDirectMPEG4Control);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FaceEngineLoader.this.jce.addJComponent((JComponent)faceUIPanel);
                }
            });
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Player getFacePlayer() {
        return this.facePlayer;
    }

    public FaceController getFaceController() {
        if (this.m4e != null) {
            return this.m4e.getFaceController();
        }
        return null;
    }

    public PlanManager<TimedFaceUnit> getPlanManager() {
        return this.planManager;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }
}

