/*
 * Decompiled with CFR 0.152.
 */
package hmi.faceengine.lipsync;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.lipsync.LipSynchProvider;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.OffsetPeg;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.faceanimation.FaceController;
import hmi.faceengine.faceunit.TimedFaceUnit;
import hmi.faceengine.viseme.VisemeBinding;
import hmi.tts.Visime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedFaceUnitLipSynchProvider
implements LipSynchProvider {
    private static final Logger log = LoggerFactory.getLogger(TimedFaceUnitLipSynchProvider.class);
    private final VisemeBinding visimeBinding;
    private final FaceController faceController;
    private final PlanManager<TimedFaceUnit> facePlanManager;

    public TimedFaceUnitLipSynchProvider(VisemeBinding visBinding, FaceController fc, PlanManager<TimedFaceUnit> facePlanManager) {
        this.visimeBinding = visBinding;
        this.faceController = fc;
        this.facePlanManager = facePlanManager;
    }

    public void addLipSyncMovement(BMLBlockPeg bbPeg, Behaviour beh, TimedPlanUnit bs, List<Visime> visemes) {
        ArrayList<TimedFaceUnit> tfus = new ArrayList<TimedFaceUnit>();
        double totalDuration = 0.0;
        double prevDuration = 0.0;
        TimedFaceUnit tfu = this.visimeBinding.getVisemeUnit(bbPeg, beh, -1, this.faceController);
        tfu.setSubUnit(true);
        HashMap<TimedFaceUnit, Double> startTimes = new HashMap<TimedFaceUnit, Double>();
        HashMap<TimedFaceUnit, Double> endTimes = new HashMap<TimedFaceUnit, Double>();
        startTimes.put(tfu, 0.0);
        endTimes.put(tfu, 0.0);
        for (Visime vis : visemes) {
            double start = totalDuration / 1000.0 - prevDuration / 2000.0;
            double peak = totalDuration / 1000.0 + (double)vis.getDuration() / 2000.0;
            double end = totalDuration / 1000.0 + (double)vis.getDuration() / 1000.0;
            endTimes.put(tfu, peak);
            tfu = this.visimeBinding.getVisemeUnit(bbPeg, beh, vis.getNumber(), this.faceController);
            startTimes.put(tfu, start);
            endTimes.put(tfu, end);
            tfus.add(tfu);
            totalDuration += (double)vis.getDuration();
            prevDuration = vis.getDuration();
        }
        tfu = this.visimeBinding.getVisemeUnit(bbPeg, beh, -1, this.faceController);
        tfus.add(tfu);
        startTimes.put(tfu, totalDuration / 1000.0);
        endTimes.put(tfu, totalDuration / 1000.0);
        for (TimedFaceUnit vfu : tfus) {
            vfu.setSubUnit(true);
            this.facePlanManager.addPlanUnit((TimedPlanUnit)vfu);
        }
        for (TimedFaceUnit plannedFU : tfus) {
            OffsetPeg startPeg = new OffsetPeg(bs.getTimePeg("start"), ((Double)startTimes.get((Object)plannedFU)).doubleValue());
            plannedFU.setTimePeg("start", (TimePeg)startPeg);
            OffsetPeg endPeg = new OffsetPeg(bs.getTimePeg("start"), ((Double)endTimes.get((Object)plannedFU)).doubleValue());
            plannedFU.setTimePeg("end", (TimePeg)endPeg);
            log.debug("adding face movement at {}-{}", (Object)plannedFU.getStartTime(), (Object)plannedFU.getEndTime());
        }
    }
}

